/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.cmsencryption;

import com.google.common.collect.ImmutableMap;
import de.adorsys.datasafe.encrypiton.api.types.encryption.CmsEncryptionConfig;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import java.util.Map;
import javax.inject.Inject;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

@RuntimeDelegate
public class ASNCmsEncryptionConfig {
    private static final Map<String, ASN1ObjectIdentifier> MAPPINGS = ImmutableMap.builder().put((Object)"AES128_CBC", (Object)NISTObjectIdentifiers.id_aes128_CBC).put((Object)"AES192_CBC", (Object)NISTObjectIdentifiers.id_aes192_CBC).put((Object)"AES256_CBC", (Object)NISTObjectIdentifiers.id_aes256_CBC).put((Object)"AES128_CCM", (Object)NISTObjectIdentifiers.id_aes128_CCM).put((Object)"AES192_CCM", (Object)NISTObjectIdentifiers.id_aes192_CCM).put((Object)"AES256_CCM", (Object)NISTObjectIdentifiers.id_aes256_CCM).put((Object)"AES128_GCM", (Object)NISTObjectIdentifiers.id_aes128_GCM).put((Object)"AES192_GCM", (Object)NISTObjectIdentifiers.id_aes192_GCM).put((Object)"AES256_GCM", (Object)NISTObjectIdentifiers.id_aes256_GCM).put((Object)"AES128_WRAP", (Object)NISTObjectIdentifiers.id_aes128_wrap).put((Object)"AES192_WRAP", (Object)NISTObjectIdentifiers.id_aes192_wrap).put((Object)"AES256_WRAP", (Object)NISTObjectIdentifiers.id_aes256_wrap).put((Object)"CHACHA20_POLY1305", (Object)PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305).build();
    private final ASN1ObjectIdentifier algorithm;

    @Inject
    public ASNCmsEncryptionConfig(CmsEncryptionConfig cmsEncryptionConfig) {
        String algo = cmsEncryptionConfig.getAlgo();
        if (!MAPPINGS.containsKey(algo)) {
            throw new IllegalArgumentException("Unknown ASN1 mapping for algo: " + algo);
        }
        this.algorithm = MAPPINGS.get(algo);
    }

    @Generated
    public ASN1ObjectIdentifier getAlgorithm() {
        return this.algorithm;
    }
}

