/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.cmsencryption;

import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.ASNCmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.decryptors.Decryptor;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.decryptors.DecryptorFactory;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.exceptions.DecryptionException;
import de.adorsys.datasafe.encrypiton.impl.utils.ProviderUtils;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.inject.Inject;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKEKRecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class CMSEncryptionServiceImpl
implements CMSEncryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CMSEncryptionServiceImpl.class);
    private ASNCmsEncryptionConfig encryptionConfig;

    @Inject
    public CMSEncryptionServiceImpl(ASNCmsEncryptionConfig encryptionConfig) {
        this.encryptionConfig = encryptionConfig;
    }

    public OutputStream buildEncryptionOutputStream(OutputStream dataContentStream, Set<PublicKeyIDWithPublicKey> publicKeys) {
        return this.streamEncrypt(dataContentStream, publicKeys.stream().map(it -> new JceKeyTransRecipientInfoGenerator(it.getKeyID().getValue().getBytes(), it.getPublicKey())).collect(Collectors.toSet()), this.encryptionConfig.getAlgorithm());
    }

    public OutputStream buildEncryptionOutputStream(OutputStream dataContentStream, SecretKey secretKey, KeyID keyID) {
        return this.streamEncrypt(dataContentStream, Collections.singleton(new JceKEKRecipientInfoGenerator(keyID.getValue().getBytes(), secretKey)), this.encryptionConfig.getAlgorithm());
    }

    public InputStream buildDecryptionInputStream(InputStream inputStream, Function<Set<String>, Map<String, Key>> keysByIds) {
        RecipientInformationStore recipientInfoStore = new CMSEnvelopedDataParser(inputStream).getRecipientInfos();
        if (recipientInfoStore.size() == 0) {
            throw new DecryptionException("CMS Envelope doesn't contain recipients");
        }
        Map<String, Decryptor> availableDecryptors = recipientInfoStore.getRecipients().stream().map(DecryptorFactory::decryptor).collect(Collectors.toMap(Decryptor::getKeyId, it -> it));
        Map<String, Key> keys = keysByIds.apply(availableDecryptors.keySet());
        if (keys.isEmpty()) {
            throw new DecryptionException("No keys found to decrypt");
        }
        if (keys.size() != 1) {
            throw new DecryptionException("More than one key available for decryption");
        }
        Map.Entry<String, Key> keyWithIdToDecrypt = keys.entrySet().iterator().next();
        return availableDecryptors.get(keyWithIdToDecrypt.getKey()).decryptionStream(keyWithIdToDecrypt.getValue());
    }

    private OutputStream streamEncrypt(OutputStream dataContentStream, Set<RecipientInfoGenerator> recipients, ASN1ObjectIdentifier algorithm) throws CMSException, IOException {
        CMSEnvelopedDataStreamGenerator generator = new CMSEnvelopedDataStreamGenerator();
        recipients.forEach(arg_0 -> ((CMSEnvelopedDataStreamGenerator)generator).addRecipientInfoGenerator(arg_0));
        return generator.open(dataContentStream, new JceCMSContentEncryptorBuilder(algorithm).setProvider(ProviderUtils.bcProvider).build());
    }
}

