/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.cmsencryption.decryptors;

import com.google.common.collect.ImmutableMap;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.decryptors.Decryptor;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.decryptors.KekDecryptor;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.decryptors.KeyTransDecryptor;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.exceptions.DecryptionException;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.bouncycastle.cms.RecipientInformation;

public final class DecryptorFactory {
    private static final Map<Integer, Function<RecipientInformation, Decryptor>> DECRYPTORS = ImmutableMap.of((Object)1, KekDecryptor::new, (Object)0, KeyTransDecryptor::new);

    public static Decryptor decryptor(RecipientInformation information) {
        int type = information.getRID().getType();
        Function<RecipientInformation, Decryptor> decryptor = DECRYPTORS.get(type);
        if (null == decryptor) {
            throw new DecryptionException("Unsupported decryptor type " + type);
        }
        return decryptor.apply(information);
    }

    @Generated
    private DecryptorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

