/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.document;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.impl.document.CMSDocumentReadService;
import de.adorsys.datasafe.storage.api.actions.StorageReadService;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.InputStream;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class CMSDocumentReadServiceRuntimeDelegatable
extends CMSDocumentReadService {
    private final CMSDocumentReadService delegate;

    @Inject
    public CMSDocumentReadServiceRuntimeDelegatable(@Nullable OverridesRegistry context, StorageReadService readService, PrivateKeyService privateKeyService, CMSEncryptionService cms) {
        super(readService, privateKeyService, cms);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(readService, privateKeyService, cms);
        this.delegate = context != null ? (CMSDocumentReadService)context.findOverride(CMSDocumentReadService.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public InputStream read(ReadRequest<UserIDAuth, AbsoluteLocation<PrivateResource>> request) {
        if (null == this.delegate) {
            return super.read(request);
        }
        return this.delegate.read(request);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, CMSDocumentReadService> ctorCaptor) {
        context.override(CMSDocumentReadService.class, args -> (CMSDocumentReadService)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final StorageReadService readService;
        private final PrivateKeyService privateKeyService;
        private final CMSEncryptionService cms;

        private ArgumentsCaptor(StorageReadService readService, PrivateKeyService privateKeyService, CMSEncryptionService cms) {
            this.readService = readService;
            this.privateKeyService = privateKeyService;
            this.cms = cms;
        }

        public StorageReadService getReadService() {
            return this.readService;
        }

        public PrivateKeyService getPrivateKeyService() {
            return this.privateKeyService;
        }

        public CMSEncryptionService getCms() {
            return this.cms;
        }
    }
}

