/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore;

import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyEntry;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImpl;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;

public class KeyStoreServiceImplRuntimeDelegatable
extends KeyStoreServiceImpl {
    private final KeyStoreServiceImpl delegate;

    @Inject
    public KeyStoreServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context, KeyStoreConfig config, Juggler juggler) {
        super(config, juggler);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(config, juggler);
        this.delegate = context != null ? (KeyStoreServiceImpl)context.findOverride(KeyStoreServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyCreationConfig config) {
        if (null == this.delegate) {
            return super.createKeyStore(keyStoreAuth, config);
        }
        return this.delegate.createKeyStore(keyStoreAuth, config);
    }

    @Override
    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyCreationConfig keyConfig, Map<KeyID, Optional<SecretKeyEntry>> secretKeys) {
        if (null == this.delegate) {
            return super.createKeyStore(keyStoreAuth, keyConfig, secretKeys);
        }
        return this.delegate.createKeyStore(keyStoreAuth, keyConfig, secretKeys);
    }

    @Override
    public KeyStore updateKeyStoreReadKeyPassword(KeyStore current, KeyStoreAuth currentCredentials, KeyStoreAuth newCredentials) {
        if (null == this.delegate) {
            return super.updateKeyStoreReadKeyPassword(current, currentCredentials, newCredentials);
        }
        return this.delegate.updateKeyStoreReadKeyPassword(current, currentCredentials, newCredentials);
    }

    @Override
    public List<PublicKeyIDWithPublicKey> getPublicKeys(KeyStoreAccess keyStoreAccess) {
        if (null == this.delegate) {
            return super.getPublicKeys(keyStoreAccess);
        }
        return this.delegate.getPublicKeys(keyStoreAccess);
    }

    @Override
    public PrivateKey getPrivateKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        if (null == this.delegate) {
            return super.getPrivateKey(keyStoreAccess, keyID);
        }
        return this.delegate.getPrivateKey(keyStoreAccess, keyID);
    }

    @Override
    public SecretKeySpec getSecretKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        if (null == this.delegate) {
            return super.getSecretKey(keyStoreAccess, keyID);
        }
        return this.delegate.getSecretKey(keyStoreAccess, keyID);
    }

    @Override
    public void addPasswordBasedSecretKey(KeyStoreAccess keyStoreAccess, String alias, char[] secret) {
        if (null == this.delegate) {
            super.addPasswordBasedSecretKey(keyStoreAccess, alias, secret);
        } else {
            this.delegate.addPasswordBasedSecretKey(keyStoreAccess, alias, secret);
        }
    }

    @Override
    public void removeKey(KeyStoreAccess keyStoreAccess, String alias) {
        if (null == this.delegate) {
            super.removeKey(keyStoreAccess, alias);
        } else {
            this.delegate.removeKey(keyStoreAccess, alias);
        }
    }

    @Override
    public byte[] serialize(KeyStore store, ReadStorePassword readStorePassword) {
        if (null == this.delegate) {
            return super.serialize(store, readStorePassword);
        }
        return this.delegate.serialize(store, readStorePassword);
    }

    @Override
    public KeyStore deserialize(byte[] payload, ReadStorePassword readStorePassword) {
        if (null == this.delegate) {
            return super.deserialize(payload, readStorePassword);
        }
        return this.delegate.deserialize(payload, readStorePassword);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, KeyStoreServiceImpl> ctorCaptor) {
        context.override(KeyStoreServiceImpl.class, args -> (KeyStoreServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final KeyStoreConfig config;
        private final Juggler juggler;

        private ArgumentsCaptor(KeyStoreConfig config, Juggler juggler) {
            this.config = config;
            this.juggler = juggler;
        }

        public KeyStoreConfig getConfig() {
            return this.config;
        }

        public Juggler getJuggler() {
            return this.juggler;
        }
    }
}

