/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.encrypiton.api.pathencryption.encryption.SymmetricPathEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathEncryptorDecryptor;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.dto.PathSegmentWithSecretKeyWith;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.global.PathEncryptionId;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class IntegrityPreservingUriEncryption
implements SymmetricPathEncryptionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrityPreservingUriEncryption.class);
    private static final int DOT_SLASH_PREFIX_LENGTH = 2;
    private static final String DOT_SLASH_PREFIX = "./";
    private static final String PATH_SEPARATOR = "/";
    private final Function<PathSegmentWithSecretKeyWith, String> encryptAndEncode = keyAndSegment -> this.encryptorAndEncoder((PathSegmentWithSecretKeyWith)keyAndSegment, pathEncryptorDecryptor);
    private final Function<PathSegmentWithSecretKeyWith, String> decryptAndDecode = keyAndSegment -> this.decryptorAndDecoder((PathSegmentWithSecretKeyWith)keyAndSegment, pathEncryptorDecryptor);

    @Inject
    public IntegrityPreservingUriEncryption(PathEncryptorDecryptor pathEncryptorDecryptor) {
    }

    public Uri encrypt(AuthPathEncryptionSecretKey pathEncryptionSecretKey, Uri bucketPath) {
        IntegrityPreservingUriEncryption.validateArgs(pathEncryptionSecretKey, bucketPath);
        IntegrityPreservingUriEncryption.validateUriIsRelative(bucketPath);
        Uri uri = this.processURIparts(pathEncryptionSecretKey, bucketPath, this.encryptAndEncode);
        return PathEncryptionId.AES_SIV.asUriRoot().resolve(uri);
    }

    public Uri decrypt(AuthPathEncryptionSecretKey pathEncryptionSecretKey, Uri bucketPath) {
        IntegrityPreservingUriEncryption.validateArgs(pathEncryptionSecretKey, bucketPath);
        IntegrityPreservingUriEncryption.validateUriIsRelative(bucketPath);
        bucketPath = PathEncryptionId.AES_SIV.asUriRoot().relativize(bucketPath);
        return this.processURIparts(pathEncryptionSecretKey, bucketPath, this.decryptAndDecode);
    }

    protected MessageDigest getDigest() {
        return MessageDigest.getInstance("SHA-256");
    }

    protected String decryptorAndDecoder(PathSegmentWithSecretKeyWith keyAndSegment, PathEncryptorDecryptor pathEncryptorDecryptor) {
        byte[] segment = keyAndSegment.getPath().getBytes(StandardCharsets.UTF_8);
        keyAndSegment.getDigest().update(segment);
        return new String(pathEncryptorDecryptor.decrypt(keyAndSegment.getPathEncryptionSecretKey(), this.decode(keyAndSegment.getPath()), keyAndSegment.getParentHash()), StandardCharsets.UTF_8);
    }

    protected String encryptorAndEncoder(PathSegmentWithSecretKeyWith keyAndSegment, PathEncryptorDecryptor pathEncryptorDecryptor) {
        String result = this.encode(pathEncryptorDecryptor.encrypt(keyAndSegment.getPathEncryptionSecretKey(), keyAndSegment.getPath().getBytes(StandardCharsets.UTF_8), keyAndSegment.getParentHash()));
        keyAndSegment.getDigest().update(result.getBytes(StandardCharsets.UTF_8));
        return result;
    }

    private byte[] decode(String encryptedPath) {
        if (null == encryptedPath || encryptedPath.isEmpty()) {
            return null;
        }
        return Base64.getUrlDecoder().decode(encryptedPath);
    }

    private String encode(byte[] encryptedPath) {
        if (null == encryptedPath) {
            return null;
        }
        return Base64.getUrlEncoder().encodeToString(encryptedPath);
    }

    private Uri processURIparts(AuthPathEncryptionSecretKey secretKeyEntry, Uri bucketPath, Function<PathSegmentWithSecretKeyWith, String> process) {
        StringBuilder result = new StringBuilder();
        String path = bucketPath.getRawPath();
        if (bucketPath.getRawPath().startsWith(DOT_SLASH_PREFIX)) {
            result.append(DOT_SLASH_PREFIX);
            path = bucketPath.getRawPath().substring(2);
        }
        if (path.isEmpty()) {
            return new Uri(result.toString());
        }
        String[] segments = path.split(PATH_SEPARATOR);
        return new Uri(URI.create(this.processSegments(secretKeyEntry, process, segments)));
    }

    private String processSegments(AuthPathEncryptionSecretKey secretKeyEntry, Function<PathSegmentWithSecretKeyWith, String> process, String[] segments) {
        MessageDigest digest = this.getDigest();
        digest.update(PATH_SEPARATOR.getBytes(StandardCharsets.UTF_8));
        return Arrays.stream(segments).map(it -> this.processAndAuthenticateSegment((String)it, secretKeyEntry, process, digest)).collect(Collectors.joining(PATH_SEPARATOR));
    }

    private String processAndAuthenticateSegment(String segment, AuthPathEncryptionSecretKey secretKeyEntry, Function<PathSegmentWithSecretKeyWith, String> process, MessageDigest digest) {
        MessageDigest currentDigest = (MessageDigest)digest.clone();
        return process.apply(new PathSegmentWithSecretKeyWith(digest, currentDigest.digest(), secretKeyEntry, segment));
    }

    private static void validateArgs(AuthPathEncryptionSecretKey secretKeyEntry, Uri bucketPath) {
        if (null == secretKeyEntry) {
            throw new IllegalArgumentException("Secret key should not be null");
        }
        if (null == bucketPath) {
            throw new IllegalArgumentException("Bucket path should not be null");
        }
    }

    private static void validateUriIsRelative(Uri uri) {
        if (uri.isAbsolute()) {
            throw new IllegalArgumentException("URI should be relative");
        }
    }
}

