/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.pathencryption.PathEncryption;
import de.adorsys.datasafe.encrypiton.api.pathencryption.encryption.SymmetricPathEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.function.Function;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class PathEncryptionImpl
implements PathEncryption {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PathEncryptionImpl.class);
    private final SymmetricPathEncryptionService symmetricPathEncryptionService;
    private final PrivateKeyService privateKeyService;

    @Inject
    public PathEncryptionImpl(SymmetricPathEncryptionService symmetricPathEncryptionService, PrivateKeyService privateKeyService) {
        this.symmetricPathEncryptionService = symmetricPathEncryptionService;
        this.privateKeyService = privateKeyService;
    }

    public Uri encrypt(UserIDAuth forUser, Uri path) {
        AuthPathEncryptionSecretKey pathEncryptionSecretKey = this.privateKeyService.pathEncryptionSecretKey(forUser);
        Uri encrypt = this.symmetricPathEncryptionService.encrypt(pathEncryptionSecretKey, path);
        log.debug("encrypted path {} for user {} path {}", new Object[]{encrypt, forUser.getUserID(), path});
        return encrypt;
    }

    public Function<Uri, Uri> decryptor(UserIDAuth forUser) {
        AuthPathEncryptionSecretKey pathEncryptionSecretKey = this.privateKeyService.pathEncryptionSecretKey(forUser);
        return encryptedPath -> {
            Uri decrypt = this.symmetricPathEncryptionService.decrypt(pathEncryptionSecretKey, encryptedPath);
            log.debug("decrypted path {} for user {} path {}", new Object[]{decrypt, forUser.getUserID(), encryptedPath});
            return decrypt;
        };
    }
}

