/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.pathencryption.encryption.SymmetricPathEncryptionService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathEncryptionImpl;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class PathEncryptionImplRuntimeDelegatable
extends PathEncryptionImpl {
    private final PathEncryptionImpl delegate;

    @Inject
    public PathEncryptionImplRuntimeDelegatable(@Nullable OverridesRegistry context, SymmetricPathEncryptionService symmetricPathEncryptionService, PrivateKeyService privateKeyService) {
        super(symmetricPathEncryptionService, privateKeyService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(symmetricPathEncryptionService, privateKeyService);
        this.delegate = context != null ? (PathEncryptionImpl)context.findOverride(PathEncryptionImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public Uri encrypt(UserIDAuth forUser, Uri path) {
        if (null == this.delegate) {
            return super.encrypt(forUser, path);
        }
        return this.delegate.encrypt(forUser, path);
    }

    @Override
    public Function<Uri, Uri> decryptor(UserIDAuth forUser) {
        if (null == this.delegate) {
            return super.decryptor(forUser);
        }
        return this.delegate.decryptor(forUser);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, PathEncryptionImpl> ctorCaptor) {
        context.override(PathEncryptionImpl.class, args -> (PathEncryptionImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final SymmetricPathEncryptionService symmetricPathEncryptionService;
        private final PrivateKeyService privateKeyService;

        private ArgumentsCaptor(SymmetricPathEncryptionService symmetricPathEncryptionService, PrivateKeyService privateKeyService) {
            this.symmetricPathEncryptionService = symmetricPathEncryptionService;
            this.privateKeyService = privateKeyService;
        }

        public SymmetricPathEncryptionService getSymmetricPathEncryptionService() {
            return this.symmetricPathEncryptionService;
        }

        public PrivateKeyService getPrivateKeyService() {
            return this.privateKeyService;
        }
    }
}

