/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.pathencryption;

import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathSegmentEncryptorDecryptor;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.cryptomator.siv.SivMode;

public class PathSegmentEncryptorDecryptorRuntimeDelegatable
extends PathSegmentEncryptorDecryptor {
    private final PathSegmentEncryptorDecryptor delegate;

    @Inject
    public PathSegmentEncryptorDecryptorRuntimeDelegatable(@Nullable OverridesRegistry context, SivMode sivMode) {
        super(sivMode);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(sivMode);
        this.delegate = context != null ? (PathSegmentEncryptorDecryptor)context.findOverride(PathSegmentEncryptorDecryptor.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public byte[] encrypt(AuthPathEncryptionSecretKey pathSecretKey, byte[] originalPath, byte[] associated) {
        if (null == this.delegate) {
            return super.encrypt(pathSecretKey, originalPath, associated);
        }
        return this.delegate.encrypt(pathSecretKey, originalPath, associated);
    }

    @Override
    public byte[] decrypt(AuthPathEncryptionSecretKey pathSecretKey, byte[] encryptedPath, byte[] associated) {
        if (null == this.delegate) {
            return super.decrypt(pathSecretKey, encryptedPath, associated);
        }
        return this.delegate.decrypt(pathSecretKey, encryptedPath, associated);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, PathSegmentEncryptorDecryptor> ctorCaptor) {
        context.override(PathSegmentEncryptorDecryptor.class, args -> (PathSegmentEncryptorDecryptor)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final SivMode sivMode;

        private ArgumentsCaptor(SivMode sivMode) {
            this.sivMode = sivMode;
        }

        public SivMode getSivMode() {
            return this.sivMode;
        }
    }
}

