/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.cmsencryption;

import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.ASNCmsEncryptionConfig;
import de.adorsys.datasafe.encrypiton.impl.cmsencryption.CMSEncryptionServiceImpl;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.inject.Inject;

public class CMSEncryptionServiceImplRuntimeDelegatable
extends CMSEncryptionServiceImpl {
    private final CMSEncryptionServiceImpl delegate;

    @Inject
    public CMSEncryptionServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context, ASNCmsEncryptionConfig encryptionConfig) {
        super(encryptionConfig);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(encryptionConfig);
        this.delegate = context != null ? (CMSEncryptionServiceImpl)context.findOverride(CMSEncryptionServiceImpl.class, (Object)argumentsCaptor) : null;
    }

    @Override
    public OutputStream buildEncryptionOutputStream(OutputStream dataContentStream, Set<PublicKeyIDWithPublicKey> publicKeys) {
        if (null == this.delegate) {
            return super.buildEncryptionOutputStream(dataContentStream, publicKeys);
        }
        return this.delegate.buildEncryptionOutputStream(dataContentStream, publicKeys);
    }

    @Override
    public OutputStream buildEncryptionOutputStream(OutputStream dataContentStream, SecretKey secretKey, KeyID keyID) {
        if (null == this.delegate) {
            return super.buildEncryptionOutputStream(dataContentStream, secretKey, keyID);
        }
        return this.delegate.buildEncryptionOutputStream(dataContentStream, secretKey, keyID);
    }

    @Override
    public InputStream buildDecryptionInputStream(InputStream inputStream, Function<Set<String>, Map<String, Key>> keysByIds) {
        if (null == this.delegate) {
            return super.buildDecryptionInputStream(inputStream, keysByIds);
        }
        return this.delegate.buildDecryptionInputStream(inputStream, keysByIds);
    }

    public static void overrideWith(OverridesRegistry context, Function<ArgumentsCaptor, CMSEncryptionServiceImpl> ctorCaptor) {
        context.override(CMSEncryptionServiceImpl.class, args -> (CMSEncryptionServiceImpl)ctorCaptor.apply((ArgumentsCaptor)args));
    }

    public static class ArgumentsCaptor {
        private final ASNCmsEncryptionConfig encryptionConfig;

        private ArgumentsCaptor(ASNCmsEncryptionConfig encryptionConfig) {
            this.encryptionConfig = encryptionConfig;
        }

        public ASNCmsEncryptionConfig getEncryptionConfig() {
            return this.encryptionConfig;
        }
    }
}

