/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.document;

import com.google.common.collect.ImmutableList;
import de.adorsys.datasafe.encrypiton.api.cmsencryption.CMSEncryptionService;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.storage.api.actions.StorageWriteService;
import de.adorsys.datasafe.types.api.callback.ResourceWriteCallback;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import de.adorsys.datasafe.types.api.utils.CustomizableByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;

@RuntimeDelegate
public class CMSDocumentWriteService
implements EncryptedDocumentWriteService {
    private final StorageWriteService writeService;
    private final CMSEncryptionService cms;

    @Inject
    public CMSDocumentWriteService(StorageWriteService writeService, CMSEncryptionService cms) {
        this.writeService = writeService;
        this.cms = cms;
    }

    public OutputStream write(Map<PublicKeyIDWithPublicKey, AbsoluteLocation> recipientsWithInbox) {
        int maxChunkSize = recipientsWithInbox.values().stream().map(arg_0 -> ((StorageWriteService)this.writeService).flushChunkSize(arg_0)).filter(Optional::isPresent).mapToInt(Optional::get).max().orElse(-1);
        List<OutputStream> recipients = recipientsWithInbox.values().stream().map(it -> this.writeService.write(WithCallback.noCallback((Object)it))).collect(Collectors.toList());
        FanOutStream dfsSink = maxChunkSize > 0 ? new ChunkableFanOutStream(recipients, maxChunkSize) : new FanOutStream(recipients);
        OutputStream encryptionSink = this.cms.buildEncryptionOutputStream((OutputStream)dfsSink, recipientsWithInbox.keySet());
        return new CloseCoordinatingStream(encryptionSink, (List<OutputStream>)ImmutableList.of((Object)encryptionSink, (Object)dfsSink));
    }

    public OutputStream write(WithCallback<AbsoluteLocation<PrivateResource>, ResourceWriteCallback> locationWithCallback, SecretKeyIDWithKey secretKey) {
        OutputStream dfsSink = this.writeService.write(WithCallback.builder().wrapped(locationWithCallback.getWrapped()).callbacks((Collection)locationWithCallback.getCallbacks()).build());
        OutputStream encryptionSink = this.cms.buildEncryptionOutputStream(dfsSink, secretKey.getSecretKey(), secretKey.getKeyID());
        return new CloseCoordinatingStream(encryptionSink, (List<OutputStream>)ImmutableList.of((Object)encryptionSink, (Object)dfsSink));
    }

    private static class ChunkableFanOutStream
    extends FanOutStream {
        private final int chunkSize;
        private final CustomizableByteArrayOutputStream os;

        private ChunkableFanOutStream(List<OutputStream> destinations, int chunkSize) {
            super(destinations);
            this.chunkSize = chunkSize;
            this.os = new CustomizableByteArrayOutputStream(32, 0x7FFFFFFE, 0.5);
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.needsFlush(1)) {
                this.os.write(b);
                return;
            }
            this.os.write(b);
            this.doFlush();
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            if (!this.needsFlush(len)) {
                this.os.write(bytes, off, len);
                return;
            }
            this.os.write(bytes, off, len);
            this.doFlush();
        }

        @Override
        public void close() {
            if (this.os.size() == 0) {
                super.close();
                return;
            }
            byte[] tailChunk = this.os.getBufferOrCopy();
            int size = this.os.size();
            Iterator dest = this.destinations.iterator();
            while (dest.hasNext()) {
                OutputStream destination = (OutputStream)dest.next();
                destination.write(tailChunk, 0, size);
                destination.close();
                dest.remove();
            }
        }

        private void doFlush() throws IOException {
            byte[] bytes = this.os.getBufferOrCopy();
            int size = this.os.size();
            int chunksToWrite = size / this.chunkSize;
            int written = 0;
            for (int chunkNum = 0; chunkNum < chunksToWrite; ++chunkNum) {
                super.write(bytes, written, this.chunkSize);
                written += this.chunkSize;
            }
            this.os.reset();
            if (written < size) {
                this.os.write(bytes, written, size - written);
            }
        }

        private boolean needsFlush(int addedBytes) {
            return this.os.size() + addedBytes > this.chunkSize;
        }
    }

    private static class FanOutStream
    extends OutputStream {
        protected final List<OutputStream> destinations;

        @Override
        public void write(int b) throws IOException {
            for (OutputStream destination : this.destinations) {
                destination.write(b);
            }
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            for (OutputStream destination : this.destinations) {
                destination.write(bytes, off, len);
            }
        }

        @Override
        public void close() {
            super.close();
            Iterator<OutputStream> dest = this.destinations.iterator();
            while (dest.hasNext()) {
                dest.next().close();
                dest.remove();
            }
        }

        @Generated
        public FanOutStream(List<OutputStream> destinations) {
            this.destinations = destinations;
        }
    }

    private static final class CloseCoordinatingStream
    extends OutputStream {
        private final OutputStream streamToWrite;
        private final List<OutputStream> streamsToClose;

        @Override
        public void write(int b) throws IOException {
            this.streamToWrite.write(b);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.streamToWrite.write(bytes, off, len);
        }

        @Override
        public void close() {
            super.close();
            this.streamsToClose.forEach(CloseCoordinatingStream::doClose);
        }

        private static void doClose(OutputStream stream) {
            stream.close();
        }

        @Generated
        public CloseCoordinatingStream(OutputStream streamToWrite, List<OutputStream> streamsToClose) {
            this.streamToWrite = streamToWrite;
            this.streamsToClose = streamsToClose;
        }
    }
}

