/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.impl.keystore;

import com.google.common.collect.ImmutableMap;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.encryption.KeyCreationConfig;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAccess;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.PublicKeyIDWithPublicKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyEntry;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.keymanagement.api.Juggler;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import de.adorsys.keymanagement.api.types.KeySetTemplate;
import de.adorsys.keymanagement.api.types.source.KeySet;
import de.adorsys.keymanagement.api.types.template.generated.Encrypting;
import de.adorsys.keymanagement.api.types.template.generated.Secret;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeDelegate
public class KeyStoreServiceImpl
implements KeyStoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyStoreServiceImpl.class);
    private final KeyStoreConfig config;
    private final String passwordStoreEncAlgo;
    private final Juggler juggler;

    @Inject
    public KeyStoreServiceImpl(KeyStoreConfig config, Juggler juggler) {
        this.config = config;
        this.passwordStoreEncAlgo = this.config.getPasswordKeysAlgo();
        this.juggler = juggler;
    }

    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyCreationConfig config) {
        return this.createKeyStore(keyStoreAuth, config, (Map<KeyID, Optional<SecretKeyEntry>>)ImmutableMap.of((Object)new KeyID("PATH_SECRET" + UUID.randomUUID().toString()), Optional.empty(), (Object)new KeyID("PATH_CTR_SECRET_" + UUID.randomUUID().toString()), Optional.empty(), (Object)new KeyID("PRIVATE_SECRET" + UUID.randomUUID().toString()), Optional.empty()));
    }

    public KeyStore createKeyStore(KeyStoreAuth keyStoreAuth, KeyCreationConfig keyConfig, Map<KeyID, Optional<SecretKeyEntry>> secretKeys) {
        log.debug("start create keystore ");
        KeyCreationConfig.EncryptingKeyCreationCfg encConf = keyConfig.getEncrypting();
        Supplier<char[]> passSupplier = () -> keyStoreAuth.getReadKeyPassword().getValue();
        KeySetTemplate template = KeySetTemplate.builder().generatedEncryptionKeys((Iterable)Encrypting.with().algo(encConf.getAlgo()).sigAlgo(encConf.getSigAlgo()).keySize(Integer.valueOf(encConf.getSize())).prefix("ENC").password(passSupplier).build().repeat(keyConfig.getEncKeyNumber())).generatedSecretKeys((Iterable)secretKeys.keySet().stream().map(it -> Secret.with().prefix(it.getValue()).password(passSupplier).build()).collect(Collectors.toList())).build();
        KeySet keySet = this.juggler.generateKeys().fromTemplate(template);
        KeyStore ks = this.juggler.toKeystore().generate(keySet);
        log.debug("finished create keystore ");
        return ks;
    }

    public KeyStore updateKeyStoreReadKeyPassword(KeyStore current, KeyStoreAuth currentCredentials, KeyStoreAuth newCredentials) {
        Function<String, char[]> keyPass = id -> currentCredentials.getReadKeyPassword().getValue();
        Function<String, char[]> newKeyPass = id -> newCredentials.getReadKeyPassword().getValue();
        KeySet clonedSet = this.juggler.readKeys().fromKeyStore(current, keyPass).copyToKeySet(newKeyPass);
        return this.juggler.toKeystore().generate(clonedSet, () -> null);
    }

    public List<PublicKeyIDWithPublicKey> getPublicKeys(KeyStoreAccess keyStoreAccess) {
        log.debug("get public keys");
        ArrayList<PublicKeyIDWithPublicKey> result = new ArrayList<PublicKeyIDWithPublicKey>();
        KeyStore keyStore = keyStoreAccess.getKeyStore();
        Enumeration<String> keyAliases = keyStore.aliases();
        while (keyAliases.hasMoreElements()) {
            boolean[] keyUsage;
            String keyAlias = keyAliases.nextElement();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            if (cert == null || !(keyUsage = cert.getKeyUsage())[2] && !keyUsage[3] && !keyUsage[4]) continue;
            result.add(new PublicKeyIDWithPublicKey(new KeyID(keyAlias), cert.getPublicKey()));
        }
        return result;
    }

    public PrivateKey getPrivateKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        ReadKeyPassword readKeyPassword = keyStoreAccess.getKeyStoreAuth().getReadKeyPassword();
        KeyStore keyStore = keyStoreAccess.getKeyStore();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyID.getValue(), readKeyPassword.getValue());
        return privateKey;
    }

    public SecretKeySpec getSecretKey(KeyStoreAccess keyStoreAccess, KeyID keyID) {
        KeyStore keyStore = keyStoreAccess.getKeyStore();
        char[] password = keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue();
        return (SecretKeySpec)keyStore.getKey(keyID.getValue(), password);
    }

    public void addPasswordBasedSecretKey(KeyStoreAccess keyStoreAccess, String alias, char[] secret) {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(secret);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(this.passwordStoreEncAlgo);
        SecretKey key = keyFac.generateSecret(pbeKeySpec);
        keyStoreAccess.getKeyStore().setKeyEntry(alias, key, keyStoreAccess.getKeyStoreAuth().getReadKeyPassword().getValue(), null);
    }

    public void removeKey(KeyStoreAccess keyStoreAccess, String alias) {
        keyStoreAccess.getKeyStore().deleteEntry(alias);
    }

    public byte[] serialize(KeyStore store, ReadStorePassword readStorePassword) {
        return this.juggler.serializeDeserialize().serialize(store, () -> ((ReadStorePassword)readStorePassword).getValue());
    }

    public KeyStore deserialize(byte[] payload, ReadStorePassword readStorePassword) {
        return this.juggler.serializeDeserialize().deserialize(payload, () -> ((ReadStorePassword)readStorePassword).getValue());
    }
}

