/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.metainfo.version.impl.version.latest.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.actions.VersionedList;
import de.adorsys.datasafe.metainfo.version.api.version.EncryptedLatestLinkService;
import de.adorsys.datasafe.metainfo.version.impl.version.VersionEncoderDecoder;
import de.adorsys.datasafe.metainfo.version.impl.version.types.DFSVersion;
import de.adorsys.datasafe.metainfo.version.impl.version.types.LatestDFSVersion;
import de.adorsys.datasafe.privatestore.api.PasswordClearingStream;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BaseVersionedPath;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Version;
import de.adorsys.datasafe.types.api.resource.Versioned;
import de.adorsys.datasafe.types.api.resource.VersionedUri;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import lombok.Generated;

@RuntimeDelegate
public class LatestListImpl<V extends LatestDFSVersion>
implements VersionedList<V> {
    private final V strategy;
    private final VersionEncoderDecoder encoder;
    private final ListPrivate listPrivate;
    private final EncryptedLatestLinkService latestVersionLinkLocator;

    @Inject
    public LatestListImpl(V strategy, VersionEncoderDecoder encoder, ListPrivate listPrivate, EncryptedLatestLinkService latestVersionLinkLocator) {
        this.strategy = strategy;
        this.encoder = encoder;
        this.listPrivate = listPrivate;
        this.latestVersionLinkLocator = latestVersionLinkLocator;
    }

    public PasswordClearingStream<AbsoluteLocation<ResolvedResource>> list(ListRequest<UserIDAuth, PrivateResource> request) {
        return new PasswordClearingStream(this.listVersioned(request).map(Versioned::stripVersion).map(AbsoluteLocation::new), ((UserIDAuth)request.getOwner()).getReadKeyPassword());
    }

    public PasswordClearingStream<Versioned<AbsoluteLocation<PrivateResource>, ResolvedResource, Version>> listVersioned(ListRequest<UserIDAuth, PrivateResource> request) {
        ListRequest forLatestSnapshotDir = request.toBuilder().location(this.latestVersionLinkLocator.resolveLatestLinkLocation((UserIDAuth)request.getOwner(), (PrivateResource)request.getLocation(), request.getStorageIdentifier()).getResource()).build();
        Function linkDecryptor = this.latestVersionLinkLocator.linkDecryptingReader((UserIDAuth)request.getOwner(), request.getStorageIdentifier());
        return new PasswordClearingStream(this.listPrivate.list(forLatestSnapshotDir).map(it -> this.parseVersion((AbsoluteLocation<ResolvedResource>)it, linkDecryptor)).filter(Objects::nonNull), ((UserIDAuth)request.getOwner()).getReadKeyPassword());
    }

    private Versioned<AbsoluteLocation<PrivateResource>, ResolvedResource, Version> parseVersion(AbsoluteLocation<ResolvedResource> resource, Function<AbsoluteLocation<PrivateResource>, AbsoluteLocation<PrivateResource>> linkDecryptor) {
        AbsoluteLocation<PrivateResource> privateBlob = linkDecryptor.apply((AbsoluteLocation<PrivateResource>)new AbsoluteLocation((ResourceLocation)((ResolvedResource)resource.getResource()).asPrivate()));
        VersionedUri versionedUri = this.encoder.decodeVersion(((PrivateResource)privateBlob.getResource()).decryptedPath()).orElse(null);
        if (null == versionedUri) {
            return null;
        }
        return new BaseVersionedPath((Version)new DFSVersion(versionedUri.getVersion()), privateBlob, (Object)resource.getResource());
    }

    @Generated
    public V getStrategy() {
        return this.strategy;
    }
}

