/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.storage.impl.s3;

import de.adorsys.datasafe.storage.impl.s3.BucketRouter;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import java.util.function.UnaryOperator;
import lombok.Generated;

public class StaticBucketRouter
implements BucketRouter {
    private final String bucketName;

    @Override
    public String bucketName(AbsoluteLocation resource) {
        return this.bucketName;
    }

    @Override
    public String resourceKey(AbsoluteLocation resource) {
        UnaryOperator trimStartingSlash = str -> str.replaceFirst("^/", "");
        String resourcePath = (String)trimStartingSlash.apply(resource.location().getRawPath());
        if (this.bucketName == null || "".equals(this.bucketName) || !resourcePath.contains(this.bucketName)) {
            return resourcePath;
        }
        return (String)trimStartingSlash.apply(resourcePath.substring(resourcePath.indexOf(this.bucketName) + this.bucketName.length()));
    }

    @Generated
    public StaticBucketRouter(String bucketName) {
        this.bucketName = bucketName;
    }
}

