/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.cryptalgs;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.logging.Logger;
import org.kapott.cryptalgs.RSAPrivateCrtKey2;
import org.kapott.cryptalgs.SignatureParamSpec;

public class ISO9796p2
extends SignatureSpi {
    private RSAPublicKey pubKey;
    private PrivateKey privKey;
    private MessageDigest dig;
    private SignatureParamSpec param;

    private static byte[] getSigFromISig(BigInteger iSig, BigInteger modulus) {
        BigInteger iSig2 = modulus.subtract(iSig);
        BigInteger sig = null;
        sig = iSig.compareTo(iSig2) < 0 ? iSig : iSig2;
        return sig.toByteArray();
    }

    private static BigInteger getJfromSig(BigInteger sig, BigInteger exp, BigInteger mod) {
        return sig.modPow(exp, mod);
    }

    private static BigInteger adjustJ(BigInteger J, BigInteger modulus) {
        byte[] ba = J.toByteArray();
        byte last = ba[ba.length - 1];
        if ((last & 0xF) == 12) {
            return J;
        }
        BigInteger twelve = new BigInteger("12");
        byte[] modulus2 = modulus.subtract(twelve).toByteArray();
        byte last2 = modulus2[modulus2.length - 1];
        if ((last & 0xF) == (last2 & 0xF)) {
            return modulus.subtract(J);
        }
        return null;
    }

    protected Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String parameter) {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        String provider = this.param.getProvider();
        try {
            this.dig = provider != null ? MessageDigest.getInstance(this.param.getHashAlg(), provider) : MessageDigest.getInstance(this.param.getHashAlg());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        this.privKey = privateKey;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) {
        try {
            this.dig = MessageDigest.getInstance(this.param.getHashAlg(), this.param.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
        this.pubKey = (RSAPublicKey)publicKey;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param1, Object value) {
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec param1) throws InvalidAlgorithmParameterException {
        if (!(param1 instanceof SignatureParamSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.param = (SignatureParamSpec)param1;
    }

    @Override
    protected void engineUpdate(byte b) {
        this.dig.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.engineUpdate(b[offset + i]);
        }
    }

    @Override
    protected int engineSign(byte[] output, int offset, int len) throws SignatureException {
        byte[] sig = this.engineSign();
        if (offset + len > output.length) {
            throw new SignatureException("output result too large for buffer");
        }
        System.arraycopy(sig, 0, output, offset, sig.length);
        return sig.length;
    }

    @Override
    protected byte[] engineSign() {
        BigInteger iSig;
        BigInteger bModulus;
        if (this.privKey instanceof RSAPrivateKey) {
            bModulus = ((RSAPrivateKey)this.privKey).getModulus();
        } else {
            RSAPrivateCrtKey2 key2 = (RSAPrivateCrtKey2)this.privKey;
            bModulus = key2.getP().multiply(key2.getQ());
        }
        byte[] H = this.dig.digest();
        int k = bModulus.bitLength();
        int t = 1;
        int T = 188;
        int Lh = H.length << 3;
        int padded_size = k >> 3;
        if ((k & 7) != 0) {
            ++padded_size;
        }
        byte[] paddedM = new byte[padded_size];
        paddedM[padded_size - 1] = (byte)T;
        System.arraycopy(H, 0, paddedM, padded_size - 1 - H.length, H.length);
        paddedM[padded_size - 1 - H.length - 8 - 1] = 1;
        int nof_zero_bits = k - Lh - 64 - 8 * t - 4;
        int nof_zero_bytes = nof_zero_bits - 5 - 7 >> 3;
        byte[] zero_bytes = new byte[nof_zero_bytes];
        Arrays.fill(zero_bytes, (byte)0);
        System.arraycopy(zero_bytes, 0, paddedM, padded_size - 1 - H.length - 8 - 1 - nof_zero_bytes, nof_zero_bytes);
        paddedM[padded_size - 1 - H.length - 8 - 1 - nof_zero_bytes - 1] = 96;
        byte[] F = paddedM;
        if (this.privKey instanceof RSAPrivateKey) {
            this.getLogger().fine("signing with (n,d)-algorithm");
            BigInteger bPrivExponent = ((RSAPrivateKey)this.privKey).getPrivateExponent();
            iSig = new BigInteger(1, F).modPow(bPrivExponent, bModulus);
        } else {
            this.getLogger().fine("signing with (p,q,dP,dQ,qInv)-algorithm");
            RSAPrivateCrtKey2 key2 = (RSAPrivateCrtKey2)this.privKey;
            BigInteger p = key2.getP();
            BigInteger q = key2.getQ();
            BigInteger dP = key2.getdP();
            BigInteger dQ = key2.getdQ();
            BigInteger qInv = key2.getQInv();
            BigInteger encData = new BigInteger(1, F);
            BigInteger m1 = encData.modPow(dP, p);
            BigInteger m2 = encData.modPow(dQ, q);
            BigInteger h = m1.subtract(m2).multiply(qInv).mod(p);
            iSig = m2.add(q.multiply(h));
        }
        return ISO9796p2.getSigFromISig(iSig, bModulus);
    }

    @Override
    protected boolean engineVerify(byte[] sig) {
        BigInteger modulus;
        BigInteger S = new BigInteger(1, sig);
        BigInteger exponent = this.pubKey.getPublicExponent();
        BigInteger J_ = ISO9796p2.getJfromSig(S, exponent, modulus = this.pubKey.getModulus());
        BigInteger I_ = ISO9796p2.adjustJ(J_, modulus);
        if (I_ == null) {
            this.getLogger().severe("neither x nor n-x are valid signatures");
            return false;
        }
        byte[] F_ = I_.toByteArray();
        int last = F_[F_.length - 1] & 0xFF;
        if (last != 188) {
            this.getLogger().severe("last nibble is not 0xBC");
        }
        byte[] hash = this.dig.digest();
        byte[] hash_ = new byte[hash.length];
        System.arraycopy(F_, F_.length - 1 - hash.length, hash_, 0, hash.length);
        return Arrays.equals(hash, hash_);
    }
}

