/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRAccInfo;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class GVAccInfo
extends AbstractHBCIJob {
    public GVAccInfo(HBCIPassportInternal passport) {
        super(passport, GVAccInfo.getLowlevelName(), new GVRAccInfo(passport));
        this.addConstraint("my.country", "KTV.KIK.country", "DE");
        this.addConstraint("my.blz", "KTV.KIK.blz", null);
        this.addConstraint("my.number", "KTV.number", null);
        this.addConstraint("my.subnumber", "KTV.subnumber", "");
        this.addConstraint("all", "allaccounts", "N");
    }

    public static String getLowlevelName() {
        return "AccInfo";
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRAccInfo.AccInfo info = new GVRAccInfo.AccInfo();
        info.account = new Konto();
        info.account.blz = result.get(header + ".My.KIK.blz");
        info.account.country = result.get(header + ".My.KIK.country");
        info.account.number = result.get(header + ".My.number");
        info.account.subnumber = result.get(header + ".My.subnumber");
        info.account.curr = result.get(header + ".curr");
        info.account.name = result.get(header + ".name");
        info.account.name2 = result.get(header + ".name2");
        info.account.type = result.get(header + ".accbez");
        info.comment = result.get(header + ".info");
        String st = result.get(header + ".opendate");
        if (st != null) {
            info.created = HBCIUtils.string2DateISO(st);
        }
        info.habenzins = (st = result.get(header + ".habenzins")) != null ? HBCIUtils.string2Long(st, 1000L) : -1L;
        st = result.get(header + ".sollzins");
        info.sollzins = st != null ? HBCIUtils.string2Long(st, 1000L) : -1L;
        st = result.get(header + ".overdrivezins");
        info.ueberzins = st != null ? HBCIUtils.string2Long(st, 1000L) : -1L;
        st = result.get(header + ".kredit.value");
        if (st != null) {
            info.kredit = new Value(st, result.get(header + ".kredit.curr"));
        }
        if ((st = result.get(header + ".refkto.number")) != null) {
            info.refAccount = new Konto(result.get(header + ".refkto.KIK.country"), result.get(header + ".refkto.KIK.blz"), st, result.get(header + ".refkto.subnumber"));
        }
        info.turnus = (st = result.get(header + ".turnus")) != null ? Integer.parseInt(st) : -1;
        st = result.get(header + ".versandart");
        info.versandart = st != null ? Integer.parseInt(st) : -1;
        st = result.get(header + ".acctype");
        int n = info.type = st != null ? Integer.parseInt(st) : -1;
        if (result.get(header + ".Address.name1") != null) {
            info.address = new GVRAccInfo.AccInfo.Address();
            info.address.name1 = result.get(header + ".Address.name1");
            info.address.name2 = result.get(header + ".Address.name2");
            info.address.street_pf = result.get(header + ".Address.street_pf");
            if (result.get(header + ".Address.plz") != null) {
                info.address.plz = result.get(header + ".Address.plz");
                info.address.ort = result.get(header + ".Address.ort");
                info.address.country = result.get(header + ".Address.country");
                info.address.tel = result.get(header + ".Address.tel");
                info.address.fax = result.get(header + ".Address.fax");
                info.address.email = result.get(header + ".Address.email");
            } else {
                info.address.plz_ort = result.get(header + ".Address.plz_ort");
                info.address.tel = result.get(header + ".Address.tel");
            }
        }
        ((GVRAccInfo)this.getJobResult()).addEntry(info);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

