/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRFestCondList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Value;

public class GVFestCondList
extends AbstractHBCIJob {
    public GVFestCondList(HBCIPassportInternal passport) {
        super(passport, GVFestCondList.getLowlevelName(), new GVRFestCondList(passport));
        this.addConstraint("curr", "curr", "EUR");
        this.addConstraint("maxentries", "maxentries", "");
    }

    public static String getLowlevelName() {
        return "FestCondList";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        int i = 0;
        while (true) {
            GVRFestCondList.Cond entry = new GVRFestCondList.Cond();
            String condheader = HBCIUtils.withCounter(header + ".FestCond", i);
            if (result.get(condheader + ".anlagedate") == null) break;
            entry.ablaufdatum = HBCIUtils.string2DateISO(result.get(condheader + ".ablaufdate"));
            entry.anlagedatum = HBCIUtils.string2DateISO(result.get(condheader + ".anlagedate"));
            entry.id = result.get(condheader + ".condid");
            entry.name = result.get(condheader + ".condbez");
            entry.date = HBCIUtils.strings2DateTimeISO(result.get(header + ".FestCondVersion.date"), result.get(header + ".FestCondVersion.time"));
            entry.version = result.get(header + ".FestCondVersion.version");
            String st = result.get(condheader + ".zinsmethode");
            if (st.equals("A")) {
                entry.zinsmethode = 0;
            } else if (st.equals("B")) {
                entry.zinsmethode = 1;
            } else if (st.equals("C")) {
                entry.zinsmethode = 2;
            } else if (st.equals("D")) {
                entry.zinsmethode = 3;
            } else if (st.equals("E")) {
                entry.zinsmethode = 4;
            } else if (st.equals("F")) {
                entry.zinsmethode = 5;
            }
            entry.zinssatz = HBCIUtils.string2Long(result.get(condheader + ".zinssatz"), 1000L);
            entry.minbetrag = new Value(result.get(condheader + ".MinBetrag.value"), result.get(condheader + ".MinBetrag.curr"));
            entry.name = result.get(condheader + ".condbez");
            if (result.get(condheader + ".MaxBetrag.value") != null) {
                entry.maxbetrag = new Value(result.get(condheader + ".MaxBetrag.value"), result.get(condheader + ".MaxBetrag.curr"));
            }
            ((GVRFestCondList)this.jobResult).addEntry(entry);
            ++i;
        }
    }
}

