/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRFestCondList;
import org.kapott.hbci.GV_Result.GVRFestList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class GVFestList
extends AbstractHBCIJob {
    public GVFestList(String name, HBCIPassportInternal passport) {
        super(passport, name, new GVRFestList(passport));
    }

    public GVFestList(HBCIPassportInternal passport) {
        this(GVFestList.getLowlevelName(), passport);
        this.addConstraint("my.number", "KTV.number", null);
        this.addConstraint("my.subnumber", "KTV.subnumber", "");
        this.addConstraint("my.blz", "KTV.KIK.blz", null);
        this.addConstraint("my.country", "KTV.KIK.country", "DE");
        this.addConstraint("dummy", "allaccounts", "N");
    }

    public static String getLowlevelName() {
        return "FestList";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRFestList.Entry entry = new GVRFestList.Entry();
        entry.anlagebetrag = new Value(result.get(header + ".Anlagebetrag.value"), result.get(header + ".Anlagebetrag.curr"));
        if (result.get(header + ".Anlagekto.number") != null) {
            entry.anlagekonto = new Konto();
            entry.anlagekonto.blz = result.get(header + ".Anlagekto.KIK.blz");
            entry.anlagekonto.country = result.get(header + ".Anlagekto.KIK.country");
            entry.anlagekonto.number = result.get(header + ".Anlagekto.number");
            entry.anlagekonto.subnumber = result.get(header + ".Anlagekto.subnumber");
            this.passport.fillAccountInfo(entry.anlagekonto);
        }
        if (result.get(header + ".Ausbuchungskto.number") != null) {
            entry.ausbuchungskonto = new Konto();
            entry.ausbuchungskonto.blz = result.get(header + ".Ausbuchungskto.KIK.blz");
            entry.ausbuchungskonto.country = result.get(header + ".Ausbuchungskto.KIK.country");
            entry.ausbuchungskonto.number = result.get(header + ".Ausbuchungskto.number");
            entry.ausbuchungskonto.subnumber = result.get(header + ".Ausbuchungskto.subnumber");
            this.passport.fillAccountInfo(entry.ausbuchungskonto);
        }
        entry.belastungskonto = new Konto();
        entry.belastungskonto.blz = result.get(header + ".Belastungskto.KIK.blz");
        entry.belastungskonto.country = result.get(header + ".Belastungskto.KIK.country");
        entry.belastungskonto.number = result.get(header + ".Belastungskto.number");
        entry.belastungskonto.subnumber = result.get(header + ".Belastungskto.subnumber");
        this.passport.fillAccountInfo(entry.belastungskonto);
        if (result.get(header + ".Zinskto.number") != null) {
            entry.zinskonto = new Konto();
            entry.zinskonto.blz = result.get(header + ".Zinskto.KIK.blz");
            entry.zinskonto.country = result.get(header + ".Zinskto.KIK.country");
            entry.zinskonto.number = result.get(header + ".Zinskto.number");
            entry.zinskonto.subnumber = result.get(header + ".Zinskto.subnumber");
            this.passport.fillAccountInfo(entry.zinskonto);
        }
        entry.id = result.get(header + ".kontakt");
        String st = result.get(header + ".kontoauszug");
        entry.kontoauszug = st != null ? Integer.parseInt(st) : 0;
        st = result.get(header + ".status");
        entry.status = st != null ? Integer.parseInt(st) : 0;
        entry.verlaengern = result.get(header + ".wiederanlage").equals("2");
        if (result.get(header + ".Zinsbetrag.value") != null) {
            entry.zinsbetrag = new Value(result.get(header + ".Zinsbetrag.value"), result.get(header + ".Zinsbetrag.curr"));
        }
        entry.konditionen = new GVRFestCondList.Cond();
        entry.konditionen.ablaufdatum = HBCIUtils.string2DateISO(result.get(header + ".FestCond.ablaufdate"));
        entry.konditionen.anlagedatum = HBCIUtils.string2DateISO(result.get(header + ".FestCond.anlagedate"));
        entry.konditionen.id = result.get(header + ".FestCond.condid");
        entry.konditionen.name = result.get(header + ".FestCond.condbez");
        if (result.get(header + ".FestCondVersion.version") != null) {
            entry.konditionen.date = HBCIUtils.strings2DateTimeISO(result.get(header + ".FestCondVersion.date"), result.get(header + ".FestCondVersion.time"));
            entry.konditionen.version = result.get(header + ".FestCondVersion.version");
        }
        if ((st = result.get(header + ".FestCond.zinsmethode")).equals("A")) {
            entry.konditionen.zinsmethode = 0;
        } else if (st.equals("B")) {
            entry.konditionen.zinsmethode = 1;
        } else if (st.equals("C")) {
            entry.konditionen.zinsmethode = 2;
        } else if (st.equals("D")) {
            entry.konditionen.zinsmethode = 3;
        } else if (st.equals("E")) {
            entry.konditionen.zinsmethode = 4;
        } else if (st.equals("F")) {
            entry.konditionen.zinsmethode = 5;
        }
        entry.konditionen.zinssatz = HBCIUtils.string2Long(result.get(header + ".FestCond.zinssatz"), 1000L);
        entry.konditionen.minbetrag = new Value(result.get(header + ".FestCond.MinBetrag.value"), result.get(header + ".FestCond.MinBetrag.curr"));
        entry.konditionen.name = result.get(header + ".FestCond.condbez");
        if (result.get(header + ".FestCond.MaxBetrag.value") != null) {
            entry.konditionen.maxbetrag = new Value(result.get(header + ".FestCond.MaxBetrag.value"), result.get(header + ".FestCond.MaxBetrag.curr"));
        }
        if (result.get(header + ".Prolong.laufzeit") != null) {
            entry.verlaengerung = new GVRFestList.Entry.Prolong();
            entry.verlaengerung.betrag = new Value(result.get(header + ".Prolong.BTG.value"), result.get(header + ".Prolong.BTG.curr"));
            entry.verlaengerung.laufzeit = Integer.parseInt(result.get(header + ".Prolong.laufzeit"));
            entry.verlaengerung.verlaengern = result.get(header + ".Prolong.wiederanlage").equals("2");
        }
        ((GVRFestList)this.jobResult).addEntry(entry);
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

