/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.swift.Swift;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVKUmsAll
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(GVKUmsAll.class);

    GVKUmsAll(HBCIPassportInternal passport, String name) {
        super(passport, name, new GVRKUms(passport));
    }

    public GVKUmsAll(HBCIPassportInternal passport) {
        this(passport, GVKUmsAll.getLowlevelName());
        boolean sepa = false;
        try {
            sepa = this.getSegVersion() >= 7;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        boolean nat = this.canNationalAcc(passport);
        if (sepa) {
            this.addConstraint("my.bic", "KTV.bic", null);
            this.addConstraint("my.iban", "KTV.iban", null);
        }
        if (nat || !sepa) {
            this.addConstraint("my.country", "KTV.KIK.country", "DE");
            this.addConstraint("my.blz", "KTV.KIK.blz", null);
            this.addConstraint("my.number", "KTV.number", null);
            this.addConstraint("my.subnumber", "KTV.subnumber", "");
        }
        this.addConstraint("startdate", "startdate", "");
        this.addConstraint("enddate", "enddate", "");
        this.addConstraint("maxentries", "maxentries", "");
        this.addConstraint("dummy", "allaccounts", "N");
    }

    public static String getLowlevelName() {
        return "KUmsZeit";
    }

    @Override
    protected void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        HashMap<String, String> result = msgstatus.getData();
        GVRKUms umsResult = (GVRKUms)this.jobResult;
        String rawData = result.get(header + ".booked");
        if (rawData != null) {
            umsResult.appendMt940raw(new StringBuilder(Swift.decodeUmlauts(rawData)));
        }
        if ((rawData = result.get(header + ".notbooked")) != null) {
            umsResult.appendMt942raw(new StringBuilder(Swift.decodeUmlauts(rawData)));
        }
        this.jobResult.storeResult("notbooked", result.get(header + ".notbooked"));
    }

    @Override
    public void verifyConstraints() {
        super.verifyConstraints();
        this.checkAccountCRC("my");
    }
}

