/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.HBCIJobResultImpl;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVSEPAInfo
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(GVSEPAInfo.class);

    public GVSEPAInfo(HBCIPassportInternal passport) {
        super(passport, GVSEPAInfo.getLowlevelName(), new HBCIJobResultImpl(passport));
    }

    public static String getLowlevelName() {
        return "SEPAInfo";
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String subheader;
        String cansepa;
        HashMap<String, String> result = msgstatus.getData();
        Map<String, String> upd = this.passport.getUPD();
        int i = 0;
        while ((cansepa = (String)result.get((subheader = HBCIUtils.withCounter(header + ".Acc", i)) + ".sepa")) != null) {
            if (!cansepa.equals("N")) {
                String temp_header;
                String temp_number;
                String iban = (String)result.get(subheader + ".iban");
                String bic = (String)result.get(subheader + ".bic");
                String country = (String)result.get(subheader + ".KIK.country");
                String blz = (String)result.get(subheader + ".KIK.blz");
                String number = (String)result.get(subheader + ".number");
                log.debug("found BIC/IBAN = " + bic + "/" + iban + " for account " + country + "/" + blz + "/" + number);
                int j = 0;
                while ((temp_number = upd.get((temp_header = HBCIUtils.withCounter("KInfo", j)) + ".KTV.number")) != null) {
                    String temp_country = upd.get(temp_header + ".KTV.KIK.country");
                    String temp_blz = upd.get(temp_header + ".KTV.KIK.blz");
                    if (temp_country.equals(country) && temp_blz.equals(blz) && temp_number.equals(number)) {
                        upd.put(temp_header + ".KTV.iban", iban);
                        upd.put(temp_header + ".KTV.bic", bic);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

