/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV;

import java.util.HashMap;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV_Result.GVRTANMediaList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GVTANMediaList
extends AbstractHBCIJob {
    private static final Logger log = LoggerFactory.getLogger(GVTANMediaList.class);

    public GVTANMediaList(HBCIPassportInternal passport) {
        super(passport, GVTANMediaList.getLowlevelName(), new GVRTANMediaList(passport));
        this.addConstraint("mediatype", "mediatype", "0");
        this.addConstraint("mediacategory", "mediacategory", "A");
    }

    public static String getLowlevelName() {
        return "TANMediaList";
    }

    @Override
    public void extractResults(HBCIMsgStatus msgstatus, String header, int idx) {
        String mediaheader;
        HashMap<String, String> result = msgstatus.getData();
        String tanOption = result.get(header + ".tanoption");
        if (tanOption != null) {
            ((GVRTANMediaList)this.jobResult).setTanOption(Integer.parseInt(tanOption));
        }
        int i = 0;
        while ((tanOption = result.get((mediaheader = HBCIUtils.withCounter(header + ".MediaInfo", i)) + ".mediacategory")) != null) {
            boolean haveName;
            GVRTANMediaList.TANMediaInfo info = new GVRTANMediaList.TANMediaInfo();
            info.mediaCategory = tanOption;
            info.cardNumber = result.get(mediaheader + ".cardnumber");
            info.cardSeqNumber = result.get(mediaheader + ".cardseqnumber");
            info.mediaName = result.get(mediaheader + ".medianame");
            info.mobileNumber = result.get(mediaheader + ".mobilenumber");
            info.mobileNumberSecure = result.get(mediaheader + ".mobilenumber_secure");
            info.status = result.get(mediaheader + ".status");
            info.tanListNumber = result.get(mediaheader + ".tanlistnumber");
            tanOption = result.get(mediaheader + ".freetans");
            if (tanOption != null) {
                info.freeTans = Integer.parseInt(tanOption);
            }
            if ((tanOption = result.get(mediaheader + ".cardtype")) != null) {
                info.cardType = Integer.parseInt(tanOption);
            }
            if ((tanOption = result.get(mediaheader + ".validfrom")) != null) {
                info.validFrom = HBCIUtils.string2DateISO(tanOption);
            }
            if ((tanOption = result.get(mediaheader + ".validto")) != null) {
                info.validTo = HBCIUtils.string2DateISO(tanOption);
            }
            if ((tanOption = result.get(mediaheader + ".lastuse")) != null) {
                info.lastUse = HBCIUtils.string2DateISO(tanOption);
            }
            if ((tanOption = result.get(mediaheader + ".activatedon")) != null) {
                info.activatedOn = HBCIUtils.string2DateISO(tanOption);
            }
            boolean isActive = info.status != null && info.status.equals("1");
            boolean bl = haveName = info.mediaName != null && info.mediaName.length() > 0;
            if (isActive && haveName) {
                log.info("adding TAN media: " + info.mediaName);
                ((GVRTANMediaList)this.jobResult).add(info);
            }
            ++i;
        }
    }
}

