/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.generators;

import java.util.logging.Logger;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.generators.PainGeneratorIf;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.sepa.SepaVersion;

public class PainGeneratorFactory {
    private static final Logger LOG = Logger.getLogger(PainGeneratorFactory.class.getName());

    public static PainGeneratorIf get(AbstractHBCIJob job, SepaVersion version) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String jobname = ((AbstractSEPAGV)job).getPainJobName();
        return PainGeneratorFactory.get(jobname, version);
    }

    public static PainGeneratorIf get(String jobname, SepaVersion version) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!version.canGenerate(jobname)) {
            throw new InvalidUserDataException("SEPA version is not supported: " + version);
        }
        String className = version.getGeneratorClass(jobname);
        LOG.fine("trying to init SEPA creator: " + className);
        Class<?> cl = Class.forName(className);
        return (PainGeneratorIf)cl.newInstance();
    }
}

