/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV.parsers;

import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.sepa.SepaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEPAParserFactory {
    private static final Logger log = LoggerFactory.getLogger(SEPAParserFactory.class);

    public static ISEPAParser get(SepaVersion version) {
        ISEPAParser parser;
        String className = version.getParserClass();
        try {
            log.debug("trying to init SEPA parser: " + className);
            Class<?> cl = Class.forName(className);
            parser = (ISEPAParser)cl.newInstance();
        }
        catch (Exception e) {
            String msg = "Error creating SEPA parser";
            throw new HBCI_Exception(msg, e);
        }
        return parser;
    }

    private SEPAParserFactory() {
    }
}

