/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.GV_Result;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.status.HBCIStatus;

public class HBCIJobResultImpl
implements Serializable,
HBCIJobResult {
    public HBCIStatus jobStatus;
    public HBCIStatus globStatus;
    private HBCIPassportInternal passport;
    private HashMap<String, String> resultData;

    public HBCIJobResultImpl(HBCIPassportInternal passport) {
        this.passport = passport;
        this.resultData = new HashMap();
        this.jobStatus = new HBCIStatus();
        this.globStatus = new HBCIStatus();
    }

    public void storeResult(String key, String value) {
        if (value != null) {
            this.resultData.put(key, value);
        }
    }

    @Override
    public int getResultsSize() {
        return this.jobStatus.getRetVals().size();
    }

    @Override
    public HBCIRetVal getRetVal(int idx) {
        return this.jobStatus.getRetVals().get(idx);
    }

    @Override
    public boolean isOK() {
        return this.globStatus.getStatusCode() != 2 && this.jobStatus.getStatusCode() != 2 && (this.globStatus.getStatusCode() != 1 || this.jobStatus.getStatusCode() != 1);
    }

    @Override
    public String getDialogId() {
        return this.resultData.get("basic.dialogid");
    }

    @Override
    public String getMsgNum() {
        return this.resultData.get("basic.msgnum");
    }

    @Override
    public String getSegNum() {
        return this.resultData.get("basic.segnum");
    }

    @Override
    public String getJobId() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        return format.format(new Date()) + "/" + this.getDialogId() + "/" + this.getMsgNum() + "/" + this.getSegNum();
    }

    @Override
    public Map<String, String> getResultData() {
        return this.resultData;
    }

    @Override
    public HBCIStatus getGlobStatus() {
        return this.globStatus;
    }

    @Override
    public HBCIStatus getJobStatus() {
        return this.jobStatus;
    }

    @Override
    public HBCIPassportInternal getPassport() {
        return this.passport;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        Object[] a = this.resultData.keySet().toArray();
        Arrays.sort(a);
        for (Object o : a) {
            String key = (String)o;
            ret.append(key).append(" = ").append(this.resultData.get(key)).append(System.getProperty("line.separator"));
        }
        return ret.toString().trim();
    }
}

