/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.datatypes;

import java.text.SimpleDateFormat;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.exceptions.InvalidUserDataException;
import org.kapott.hbci.manager.HBCIUtils;

public final class SyntaxDate
extends SyntaxDE {
    public SyntaxDate(String x, int minsize, int maxsize) {
        super(SyntaxDate.parseDate(x), 8, 8);
    }

    public SyntaxDate(StringBuilder res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    private static String parseDate(String x) {
        return new SimpleDateFormat("yyyyMMdd").format(HBCIUtils.string2DateISO(x));
    }

    @Override
    public void init(String x, int minsize, int maxsize) {
        super.init(SyntaxDate.parseDate(x), 8, 8);
    }

    private void initData(StringBuilder res, int minsize, int maxsize) {
        int startidx = SyntaxDate.skipPreDelim(res);
        int endidx = SyntaxDate.findNextDelim(res, startidx);
        String st = res.substring(startidx, endidx);
        this.unparseDate(st);
        this.setContent(st, 8, 8);
        res.delete(0, endidx);
    }

    @Override
    public void init(StringBuilder res, int minsize, int maxsize) {
        this.initData(res, minsize, maxsize);
    }

    private String unparseDate(String x) {
        try {
            return HBCIUtils.date2StringISO(new SimpleDateFormat("yyyyMMdd").parse(x));
        }
        catch (Exception e) {
            throw new InvalidUserDataException(HBCIUtils.getLocMsg("EXCMSG_DATEERR"), e);
        }
    }

    @Override
    public String toString() {
        String c = this.getContent();
        return c == null ? "" : this.unparseDate(c);
    }
}

