/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.manager;

import java.util.List;
import org.kapott.hbci.status.HBCIRetVal;

public enum KnownReturncode {
    W3040("3040"),
    W3072("3072"),
    W3076("3076"),
    W3920("3920"),
    E9340("9340"),
    E9942("9942");

    public static final KnownReturncode[] LIST_AUTH_FAIL;
    private String code = null;

    private KnownReturncode(String code) {
        this.code = code;
    }

    public static boolean contains(String code, KnownReturncode ... codes) {
        return KnownReturncode.find(code, codes) != null;
    }

    public static KnownReturncode find(String code, KnownReturncode ... codes) {
        if (code == null || code.length() == 0 || codes == null || codes.length == 0) {
            return null;
        }
        for (KnownReturncode c : codes) {
            if (!c.is(code)) continue;
            return c;
        }
        return null;
    }

    public boolean is(String code) {
        return this.code.equals(code);
    }

    public HBCIRetVal searchReturnValue(List<HBCIRetVal> rets) {
        if (rets == null || rets.isEmpty()) {
            return null;
        }
        return rets.stream().filter(hbciRetVal -> this.is(hbciRetVal.code)).findAny().orElse(null);
    }

    static {
        LIST_AUTH_FAIL = new KnownReturncode[]{E9340, E9942};
    }
}

