/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kapott.hbci.datatypes.SyntaxDE;
import org.kapott.hbci.datatypes.factory.SyntaxDEFactory;
import org.kapott.hbci.exceptions.NoValidValueException;
import org.kapott.hbci.exceptions.NoValueGivenException;
import org.kapott.hbci.exceptions.OverwriteException;
import org.kapott.hbci.exceptions.ParseErrorException;
import org.kapott.hbci.exceptions.PredelimErrorException;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DE
extends SyntaxElement {
    private SyntaxDE value;
    private int minsize;
    private int maxsize;
    private List<String> valids;

    public DE(Node dedef, String name, String path, int idx, Document document) {
        super(((Element)dedef).getAttribute("type"), name, path, idx, null);
        this.initData(dedef, name, path, idx, document);
    }

    public DE(Node dedef, String name, String path, char predelim, int idx, StringBuilder res, int fullResLen, Map<String, String> predefs, Map<String, String> valids) {
        super(((Element)dedef).getAttribute("type"), name, path, predelim, idx, res, fullResLen, null, predefs, valids);
        this.initData(dedef, res, predefs, predelim, valids);
    }

    @Override
    protected MultipleSyntaxElements createNewChildContainer(Node dedef, Document document) {
        return null;
    }

    @Override
    protected String getElementTypeName() {
        return "DE";
    }

    @Override
    public boolean propagateValue(String destPath, String valueString, boolean tryToCreate, boolean allowOverwrite) {
        boolean ret = false;
        if (destPath.equals(this.getPath())) {
            if (this.value != null && !allowOverwrite) {
                throw new OverwriteException(this.getPath(), this.value.toString(), valueString);
            }
            this.setValue(valueString);
            ret = true;
        }
        return ret;
    }

    @Override
    public String getValueOfDE(String path) {
        String ret = null;
        if (path.equals(this.getPath())) {
            ret = this.value.toString();
        }
        return ret;
    }

    @Override
    public String getValueOfDE(String path, int zero) {
        String ret = null;
        if (path.equals(this.getPath())) {
            ret = this.value.toString(0);
        }
        return ret;
    }

    private void initData(Node dedef, String name, String path, int idx, Document document) {
        this.value = null;
        this.valids = new ArrayList<String>();
        this.minsize = 1;
        String st = ((Element)dedef).getAttribute("minsize");
        if (st.length() != 0) {
            this.minsize = Integer.parseInt(st);
        }
        this.maxsize = 0;
        st = ((Element)dedef).getAttribute("maxsize");
        if (st.length() != 0) {
            this.maxsize = Integer.parseInt(st);
        }
    }

    public void init(Node dedef, String name, String path, int idx, Document document) {
        super.init(((Element)dedef).getAttribute("type"), name, path, idx, null);
        this.initData(dedef, name, path, idx, document);
    }

    @Override
    public void validate() {
        if (this.value == null) {
            throw new NoValueGivenException(this.getPath());
        }
        if (this.valids.size() != 0) {
            boolean ok = false;
            String valString = this.value != null ? this.value.toString() : "";
            for (int i = 0; i < this.valids.size(); ++i) {
                if (!this.valids.get(i).equals(valString)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new NoValidValueException(this.getPath(), valString);
            }
        }
        this.setValid(true);
    }

    public void setValids(List<String> valids) {
        this.valids = valids;
    }

    public int getMinSize() {
        return this.minsize;
    }

    public SyntaxDE getValue() {
        return this.value;
    }

    public void setValue(String st) {
        this.value = SyntaxDEFactory.createSyntaxDE(this.getType(), this.getPath(), st, this.minsize, this.maxsize);
    }

    @Override
    protected MultipleSyntaxElements parseNewChildContainer(Node deref, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        return null;
    }

    @Override
    protected char getInDelim() {
        return '\u0000';
    }

    private void parseValue(StringBuilder res, Map<String, String> predefs, char preDelim, Map<String, String> valids) {
        int len = res.length();
        if (preDelim != '\u0000' && res.charAt(0) != preDelim) {
            if (len == 0) {
                throw new ParseErrorException(HBCIUtils.getLocMsg("EXCMSG_ENDOFSTRG", this.getPath()));
            }
            throw new PredelimErrorException(this.getPath(), Character.toString(preDelim), Character.toString(res.charAt(0)));
        }
        this.value = SyntaxDEFactory.createSyntaxDE(this.getType(), this.getPath(), res, this.minsize, this.maxsize);
        String valueString = this.value.toString(0);
        String predefined = predefs.get(this.getPath());
        if (predefined != null && !valueString.equals(predefined)) {
            throw new ParseErrorException(HBCIUtils.getLocMsg("EXCMSG_PREDEFERR", new Object[]{this.getPath(), predefined, this.value}));
        }
        boolean atLeastOne = false;
        boolean ok = false;
        if (valids != null) {
            String header = this.getPath() + ".value";
            for (String key : valids.keySet()) {
                if (!key.startsWith(header) || key.indexOf(".", header.length()) != -1) continue;
                atLeastOne = true;
                String validValue = valids.get(key);
                if (!valueString.equals(validValue)) continue;
                ok = true;
                break;
            }
        }
        if (atLeastOne && !ok) {
            throw new NoValidValueException(this.getPath(), valueString);
        }
    }

    private void initData(Node dedef, StringBuilder res, Map<String, String> predefs, char preDelim, Map<String, String> valids) {
        this.setValid(false);
        this.value = null;
        this.valids = new ArrayList<String>();
        this.minsize = 1;
        String st = ((Element)dedef).getAttribute("minsize");
        if (st.length() != 0) {
            this.minsize = Integer.parseInt(st);
        }
        this.maxsize = 0;
        st = ((Element)dedef).getAttribute("maxsize");
        if (st.length() != 0) {
            this.maxsize = Integer.parseInt(st);
        }
        this.parseValue(res, predefs, preDelim, valids);
        this.setValid(true);
    }

    public void init(Node dedef, String name, String path, char predelim, int idx, StringBuilder res, int fullResLen, Map<String, String> predefs, Map<String, String> valids) {
        super.init(((Element)dedef).getAttribute("type"), name, path, predelim, idx, res, fullResLen, null, predefs, valids);
        this.initData(dedef, res, predefs, predelim, valids);
    }

    @Override
    public void extractValues(Map<String, String> values) {
        if (this.isValid()) {
            values.put(this.getPath(), this.value.toString());
        }
    }

    public String toString() {
        return this.isValid() ? this.value.toString() : "";
    }

    @Override
    public String toString(int dummy) {
        return this.isValid() ? this.value.toString(0) : "";
    }

    public void getElementPaths(Properties p, int[] segref, int[] degref, int[] deref) {
        if (deref == null) {
            p.setProperty(segref[0] + ":" + degref[0], this.getPath());
            degref[0] = degref[0] + 1;
        } else {
            p.setProperty(segref[0] + ":" + degref[0] + "," + deref[0], this.getPath());
            deref[0] = deref[0] + 1;
        }
    }
}

