/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.protocol;

import java.util.Map;
import org.kapott.hbci.protocol.DEG;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class MultipleDEGs
extends MultipleSyntaxElements {
    private static final Logger log = LoggerFactory.getLogger(MultipleDEGs.class);
    private char delimiter;

    public MultipleDEGs(Node degref, char delimiter, String path, Document document) {
        super(degref, path, document);
        this.initData(delimiter);
    }

    public MultipleDEGs(Node degref, char delimiter, String path, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        super(degref, path, predelim0, predelim1, res, fullResLen, document, predefs, valids);
        this.initData(delimiter);
    }

    @Override
    protected SyntaxElement createAndAppendNewElement(Node ref, String path, int idx, Document document) {
        DEG ret = new DEG(this.getType(), this.getName(), path, idx, document);
        this.addElement(ret);
        return ret;
    }

    private void initData(char delimiter) {
        this.delimiter = delimiter;
    }

    public void init(Node degref, char delimiter, String path, Document document) {
        super.init(degref, path, document);
        this.initData(delimiter);
    }

    @Override
    public String toString(int dummy) {
        StringBuilder ret = new StringBuilder(128);
        boolean first = true;
        for (SyntaxElement syntaxElement : this.getElements()) {
            if (!first) {
                ret.append(this.delimiter);
            }
            first = false;
            if (syntaxElement == null) continue;
            ret.append(((DEG)syntaxElement).toString(0));
        }
        return ret.toString();
    }

    @Override
    protected SyntaxElement parseAndAppendNewElement(Node ref, String path, char predelim, int idx, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        DEG ret = new DEG(this.getType(), this.getName(), path, predelim, idx, res, fullResLen, document, predefs, valids);
        this.addElement(ret);
        return ret;
    }

    public void init(Node degref, char delimiter, String path, char predelim0, char predelim1, StringBuilder res, int fullResLen, Document document, Map<String, String> predefs, Map<String, String> valids) {
        super.init(degref, path, predelim0, predelim1, res, fullResLen, document, predefs, valids);
        this.initData(delimiter);
    }

    @Override
    public void getElementPaths(Map<String, String> p, int[] segref, int[] degref, int[] deref) {
        if (this.getElements().size() != 0) {
            for (SyntaxElement e : this.getElements()) {
                if (e == null) continue;
                e.getElementPaths(p, segref, degref, deref);
            }
        } else if (deref == null) {
            p.put(segref[0] + ":" + degref[0], this.getPath());
            degref[0] = degref[0] + 1;
        } else {
            p.put(segref[0] + ":" + degref[0] + "," + degref[0], this.getPath());
            deref[0] = deref[0] + 1;
        }
    }
}

