/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.rewrite;

import java.util.Map;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.rewrite.Rewrite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RKUmsEmptyBDateSets
extends Rewrite {
    private static final Logger log = LoggerFactory.getLogger(RKUmsEmptyBDateSets.class);

    private String rewriteKUms(String st) {
        int posi;
        StringBuffer temp = new StringBuffer(st);
        boolean foundError = false;
        while ((posi = temp.indexOf("\r\n-\r\n-\r\n")) != -1) {
            temp.delete(posi, posi + 3);
            foundError = true;
        }
        if (foundError) {
            log.error("rewriter KUmsEmptyBDateSets: found empty bdate sets: " + foundError);
        } else {
            log.warn("rewriter KUmsEmptyBDateSets: found empty bdate sets: " + foundError);
        }
        return temp.toString();
    }

    @Override
    public Message incomingData(Message msg) {
        String header = "GVRes";
        Map<String, String> data = msg.getData();
        for (String key : data.keySet()) {
            if (!key.startsWith(header) || key.indexOf("KUms") == -1 || !key.endsWith(".booked")) continue;
            String st = msg.getValueOfDE(msg.getName() + "." + key);
            st = this.rewriteKUms(st);
            msg.propagateValue(msg.getName() + "." + key, "B" + st, false, true);
        }
        return msg;
    }
}

