/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.status.HBCIRetVal;
import org.kapott.hbci.status.HBCIStatus;

public final class HBCIMsgStatus {
    private static final List<String> invalidPinCodes = Arrays.asList("9931", "9942", "9340");
    public HBCIStatus globStatus = new HBCIStatus();
    public HBCIStatus segStatus = new HBCIStatus();
    private HashMap<String, String> data = new HashMap();

    public void addException(Exception e) {
        this.globStatus.addException(e);
    }

    public void addData(Map<String, String> _data) {
        this.data.putAll(_data);
        this.extractStatusData();
    }

    private void extractStatusData() {
        String segheader;
        String segref;
        this.globStatus = new HBCIStatus();
        this.segStatus = new HBCIStatus();
        int i = 0;
        while (true) {
            HBCIRetVal rv;
            try {
                rv = new HBCIRetVal(this.data, HBCIUtils.withCounter("RetGlob.RetVal", i));
            }
            catch (Exception e) {
                break;
            }
            this.globStatus.addRetVal(rv);
            ++i;
        }
        i = 0;
        while ((segref = this.data.get((segheader = HBCIUtils.withCounter("RetSeg", i)) + ".SegHead.ref")) != null) {
            int j = 0;
            while (true) {
                HBCIRetVal rv = null;
                try {
                    rv = new HBCIRetVal(this.data, HBCIUtils.withCounter(segheader + ".RetVal", j), segref);
                }
                catch (Exception e) {
                    break;
                }
                this.segStatus.addRetVal(rv);
                ++j;
            }
            ++i;
        }
    }

    public HashMap<String, String> getData() {
        return this.data;
    }

    public void setData(HashMap<String, String> data) {
        this.data = data;
        this.extractStatusData();
    }

    public boolean hasExceptions() {
        return this.globStatus.hasExceptions();
    }

    public Exception[] getExceptions() {
        return this.globStatus.getExceptions();
    }

    public boolean isOK() {
        return this.globStatus.getStatusCode() == 0;
    }

    public List<String> getErrorList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.globStatus.getErrorList());
        ret.addAll(this.segStatus.getErrorList());
        return ret;
    }

    public List<String> getWarningsList() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.globStatus.getWarningsList());
        ret.addAll(this.segStatus.getWarningsList());
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.globStatus.toString());
        ret.append(System.getProperty("line.separator"));
        ret.append(this.segStatus.toString());
        return ret.toString().trim();
    }

    public String getInvalidPinCode() {
        for (HBCIRetVal hbciRetVal : this.globStatus.getErrors()) {
            if (!invalidPinCodes.contains(hbciRetVal.code)) continue;
            return hbciRetVal.code;
        }
        for (HBCIRetVal hbciRetVal : this.segStatus.getErrors()) {
            if (!invalidPinCodes.contains(hbciRetVal.code)) continue;
            return hbciRetVal.code;
        }
        return null;
    }

    public boolean isDialogClosed() {
        for (HBCIRetVal hbciRetVal : this.globStatus.getErrors()) {
            if (!hbciRetVal.code.equals("9800")) continue;
            return true;
        }
        for (HBCIRetVal hbciRetVal : this.segStatus.getErrors()) {
            if (!hbciRetVal.code.equals("9800")) continue;
            return true;
        }
        return false;
    }

    public int findTaskSegment() {
        HashMap<String, String> result = this.getData();
        for (int segnum = 1; segnum < 1000; ++segnum) {
            String path = result.get(Integer.toString(segnum));
            if (path == null) {
                return -1;
            }
            if (!path.startsWith("CustomMsg.GV")) continue;
            return segnum;
        }
        return -1;
    }
}

