/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.structures.Konto;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransactionsToXML {
    public void createTransactionElements(Document doc, Element troot, List<GVRKUms.UmsLine> transactions) {
        for (GVRKUms.UmsLine transaction : transactions) {
            Element transElem = doc.createElement("transaction");
            troot.appendChild(transElem);
            Element vdate = doc.createElement("value_date");
            vdate.appendChild(doc.createTextNode(HBCIUtils.date2StringISO(transaction.valuta)));
            transElem.appendChild(vdate);
            Element bdate = doc.createElement("booking_date");
            bdate.appendChild(doc.createTextNode(HBCIUtils.date2StringISO(transaction.bdate)));
            transElem.appendChild(bdate);
            Element amount = doc.createElement("amount");
            amount.setAttribute("curr", transaction.value.getCurr());
            amount.appendChild(doc.createTextNode(HBCIUtils.bigDecimal2String(transaction.value.getBigDecimalValue())));
            transElem.appendChild(amount);
            Element saldo = doc.createElement("saldo");
            saldo.setAttribute("curr", transaction.saldo.value.getCurr());
            saldo.appendChild(doc.createTextNode(HBCIUtils.bigDecimal2String(transaction.saldo.value.getBigDecimalValue())));
            transElem.appendChild(saldo);
            if (!transaction.gvcode.equals("999")) {
                Element structured = doc.createElement("structured_details");
                transElem.appendChild(structured);
                Element participant = doc.createElement("participant");
                structured.appendChild(participant);
                Konto acc = transaction.other;
                Element name = doc.createElement("name");
                name.appendChild(doc.createTextNode(this.nullAsEmpty(acc != null ? acc.name : "")));
                participant.appendChild(name);
                Element name2 = doc.createElement("name2");
                name2.appendChild(doc.createTextNode(this.nullAsEmpty(acc != null ? acc.name2 : "")));
                participant.appendChild(name2);
                Element country = doc.createElement("country");
                country.appendChild(doc.createTextNode(this.nullAsEmpty(acc != null ? acc.country : "")));
                participant.appendChild(country);
                Element blz = doc.createElement("blz");
                blz.appendChild(doc.createTextNode(this.nullAsEmpty(acc != null ? acc.blz : "")));
                participant.appendChild(blz);
                Element number = doc.createElement("number");
                number.appendChild(doc.createTextNode(this.nullAsEmpty(acc != null ? acc.number : "")));
                participant.appendChild(number);
                Element descr = doc.createElement("description");
                structured.appendChild(descr);
                Iterator<String> j = transaction.usage.iterator();
                while (j.hasNext()) {
                    Element line = doc.createElement("line");
                    String usage = j.next();
                    line.appendChild(doc.createTextNode(this.nullAsEmpty(usage)));
                    descr.appendChild(line);
                }
            } else {
                Element unstructured = doc.createElement("unstructured_details");
                transElem.appendChild(unstructured);
                unstructured.appendChild(doc.createTextNode(this.nullAsEmpty(transaction.additional)));
            }
            Element btype = doc.createElement("booking_type");
            transElem.appendChild(btype);
            Element code = doc.createElement("code");
            code.appendChild(doc.createTextNode(this.nullAsEmpty(transaction.gvcode)));
            btype.appendChild(code);
            Element txt = doc.createElement("text");
            String st = "";
            if (!transaction.gvcode.equals("999")) {
                st = this.nullAsEmpty(transaction.text);
            }
            txt.appendChild(doc.createTextNode(st));
            btype.appendChild(txt);
        }
    }

    public Document createXMLDocument(List<GVRKUms.UmsLine> transactions, String rawMT940) {
        DocumentBuilder builder;
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setIgnoringComments(true);
        fac.setValidating(false);
        try {
            builder = fac.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.newDocument();
        Element root = doc.createElement("account_transactions");
        doc.appendChild(root);
        if (transactions != null) {
            Element transElement = doc.createElement("transactions");
            root.appendChild(transElement);
            this.createTransactionElements(doc, transElement, transactions);
        }
        if (rawMT940 != null) {
            Element rawElem = doc.createElement("raw");
            root.appendChild(rawElem);
            try {
                String mt940_encoded = Base64.encodeBase64String((byte[])rawMT940.getBytes(StandardCharsets.ISO_8859_1));
                rawElem.appendChild(doc.createCDATASection(mt940_encoded));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return doc;
    }

    public void writeXMLString(Document doc, OutputStream out) {
        if (doc == null) {
            throw new NullPointerException("document must not be null");
        }
        if (out == null) {
            throw new NullPointerException("output stream must not be null");
        }
        try {
            TransformerFactory transFac = TransformerFactory.newInstance();
            Transformer trans = transFac.newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("encoding", "UTF-8");
            trans.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult target = new StreamResult(out);
            trans.transform(source, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String nullAsEmpty(String st) {
        String ret = st;
        if (ret == null) {
            ret = "";
        }
        return ret;
    }
}

