/*
 * Decompiled with CFR 0.152.
 */
package org.kapott.hbci.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;

public class UpdateBLZProperties {
    private static final String ENCODING = "iso-8859-1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 3 || args.length > 4) {
            System.err.println("benoetigte Parameter: 1) fints_institute.csv, 2) blz.properties, 3) zu schreibende blz.properties");
            System.err.println("optionaler Parameter: 4) BLZ_20160606.txt (BLZ-Update der Bundesbank)");
            System.exit(1);
        }
        BufferedReader f1 = null;
        BufferedReader f2 = null;
        BufferedWriter f3 = null;
        BufferedReader f4 = null;
        String line = null;
        try {
            Object current;
            File f;
            String url;
            String[] values;
            HashMap<String, String> lookup = new HashMap<String, String>();
            HashMap<String, String> versions = new HashMap<String, String>();
            HashMap<String, Object> bicLokup = new HashMap<String, Object>();
            f1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), ENCODING));
            int count = 0;
            while ((line = f1.readLine()) != null) {
                String blz;
                if (++count <= 1 || line.trim().length() == 0 || (values = Arrays.asList(line.split(";"))).size() <= 20 || (blz = values.get(1).trim()).length() == 0 || lookup.get(blz) != null || (url = values.get(23).trim()).length() == 0) continue;
                lookup.put(blz, url);
                versions.put(blz, ((String)values.get(24)).trim());
            }
            if (args.length == 4 && (f = new File(args[3])).exists() && f.isFile() && f.canRead()) {
                f4 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), ENCODING));
                while ((line = f4.readLine()) != null) {
                    current = new BICLine(line);
                    if (((BICLine)current).blz == null || ((BICLine)current).bic == null) continue;
                    bicLokup.put(((BICLine)current).blz, current);
                }
            }
            f2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[1]), ENCODING));
            f3 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(args[2]), ENCODING));
            while ((line = f2.readLine()) != null) {
                BICLine bic;
                values = line.split("=");
                current = new Line(values[0], values[1]);
                url = (String)lookup.get(((Line)current).blz);
                String version = (String)versions.get(((Line)current).blz);
                if (f4 != null && (bic = (BICLine)bicLokup.get(((Line)current).blz)) != null) {
                    ((Line)current).updateBic(bic.bic);
                }
                ((Line)current).updateUrl(url);
                ((Line)current).updateVersion(version);
                f3.write(((Line)current).toString());
                f3.newLine();
            }
        }
        finally {
            if (f1 != null) {
                f1.close();
            }
            if (f2 != null) {
                f2.close();
            }
            if (f3 != null) {
                f3.close();
            }
            if (f4 != null) {
                f4.close();
            }
        }
    }

    private static class Line {
        private String blz = null;
        private String[] values = new String[9];

        private Line(String blz, String line) {
            this.blz = blz;
            String[] s = line.split("\\|");
            System.arraycopy(s, 0, this.values, 0, s.length);
        }

        private void updateUrl(String url) {
            if (url == null || url.length() == 0) {
                return;
            }
            String current = this.values[5];
            String string = current = current != null ? current.trim() : "";
            if (!current.equals(url)) {
                System.out.println(this.blz + ": URL \"" + current + "\" -> \"" + url + "\"");
                this.values[5] = url;
            }
        }

        private void updateBic(String bic) {
            if (bic == null || bic.length() == 0) {
                return;
            }
            String current = this.values[2];
            String string = current = current != null ? current.trim() : "";
            if (!current.equals(bic)) {
                String s2;
                if (bic.length() < 8 || current.length() < 8) {
                    return;
                }
                String s1 = bic.substring(0, 8);
                if (!s1.equals(s2 = current.substring(0, 8))) {
                    System.out.println(this.blz + ": BIC \"" + current + "\" -> \"" + bic + "\"");
                    this.values[2] = bic;
                }
            }
        }

        private void updateVersion(String version) {
            if (version == null || version.length() == 0) {
                return;
            }
            if ((version = version.toLowerCase()).contains("3.0")) {
                version = "300";
            } else if (version.contains("2.2")) {
                version = "plus";
            }
            String current = this.values[7];
            String string = current = current != null ? current.trim() : "";
            if (!current.equals(version)) {
                System.out.println(this.blz + ": Version \"" + current + "\" -> \"" + version + "\"");
                this.values[7] = version;
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.blz);
            sb.append("=");
            for (int i = 0; i < this.values.length; ++i) {
                String s;
                if (i > 0) {
                    sb.append("|");
                }
                if ((s = this.values[i]) == null) continue;
                sb.append(s);
            }
            return sb.toString();
        }
    }

    private static class BICLine {
        private String blz = null;
        private String bic = null;

        private BICLine(String line) {
            if (line == null || line.length() < 150) {
                return;
            }
            this.blz = line.substring(0, 8).trim();
            this.bic = line.substring(139, 150).trim();
            if (this.blz.length() == 0) {
                this.blz = null;
            }
            if (this.bic.length() == 0) {
                this.bic = null;
            }
        }
    }
}

