/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.generated.PbeKeyEncryptionTemplate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;

public class Pbe
implements GeneratedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final PbeKeyEncryptionTemplate encryptionTemplate;
    private final char[] data;
    private final KeyMetadata metadata;

    public Collection<Pbe> repeat(int times) {
        return IntStream.range(0, times).boxed().map(it -> this.toBuilder().build()).collect(Collectors.toList());
    }

    Pbe(@NonNull char[] data, @NonNull KeyTemplate keyTemplate, @NonNull PbeKeyEncryptionTemplate encryptionTemplate, KeyMetadata metadata) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (encryptionTemplate == null) {
            throw new NullPointerException("encryptionTemplate is marked non-null but is null");
        }
        this.data = data;
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.encryptionTemplate = encryptionTemplate;
    }

    Pbe(@NonNull char[] data, String alias, String prefix, Supplier<char[]> password, String algo, Integer saltLen, Integer iterCount, KeyMetadata metadata) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.encryptionTemplate = PbeKeyEncryptionTemplate.of(algo, saltLen, iterCount);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static Templated builder() {
        return new Templated();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Templated toBuilder() {
        return new Templated().data(this.data).keyTemplate(this.keyTemplate).encryptionTemplate(this.encryptionTemplate).metadata(this.metadata);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static PbeBuilder with() {
        return new PbeBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PbeKeyEncryptionTemplate getEncryptionTemplate() {
        return this.encryptionTemplate;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public char[] getData() {
        return this.data;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAlgo() {
        return this.getEncryptionTemplate().getAlgo();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSaltLen() {
        return this.getEncryptionTemplate().getSaltLen();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getIterCount() {
        return this.getEncryptionTemplate().getIterCount();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class Templated {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private char[] data;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyTemplate keyTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private PbeKeyEncryptionTemplate encryptionTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Templated() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated data(@NonNull char[] data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated encryptionTemplate(@NonNull PbeKeyEncryptionTemplate encryptionTemplate) {
            if (encryptionTemplate == null) {
                throw new NullPointerException("encryptionTemplate is marked non-null but is null");
            }
            this.encryptionTemplate = encryptionTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Pbe build() {
            return new Pbe(this.data, this.keyTemplate, this.encryptionTemplate, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Pbe.Templated(data=" + Arrays.toString(this.data) + ", keyTemplate=" + this.keyTemplate + ", encryptionTemplate=" + this.encryptionTemplate + ", metadata=" + this.metadata + ")";
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class PbeBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private char[] data;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String alias;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String prefix;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Supplier<char[]> password;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String algo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer saltLen;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer iterCount;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        PbeBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder data(@NonNull char[] data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder algo(String algo) {
            this.algo = algo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder saltLen(Integer saltLen) {
            this.saltLen = saltLen;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder iterCount(Integer iterCount) {
            this.iterCount = iterCount;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PbeBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Pbe build() {
            return new Pbe(this.data, this.alias, this.prefix, this.password, this.algo, this.saltLen, this.iterCount, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Pbe.PbeBuilder(data=" + Arrays.toString(this.data) + ", alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", algo=" + this.algo + ", saltLen=" + this.saltLen + ", iterCount=" + this.iterCount + ", metadata=" + this.metadata + ")";
        }
    }
}

