/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.config.keystore;

import de.adorsys.keymanagement.api.config.keystore.pbkdf.PBKDF2;
import de.adorsys.keymanagement.api.config.keystore.pbkdf.Scrypt;

public class KeyStoreConfig {
    private final String type;
    private final String encryptionAlgo;
    private final PBKDF pbkdf;
    private final String macAlgo;
    private final String passwordKeysAlgo;

    private static String $default$type() {
        return "BCFKS";
    }

    private static String $default$encryptionAlgo() {
        return "AES256_KWP";
    }

    private static PBKDF $default$pbkdf() {
        return PBKDF.builder().build();
    }

    private static String $default$macAlgo() {
        return "HmacSHA3_512";
    }

    private static String $default$passwordKeysAlgo() {
        return "PBEWithHmacSHA256AndAES_256";
    }

    KeyStoreConfig(String type, String encryptionAlgo, PBKDF pbkdf, String macAlgo, String passwordKeysAlgo) {
        this.type = type;
        this.encryptionAlgo = encryptionAlgo;
        this.pbkdf = pbkdf;
        this.macAlgo = macAlgo;
        this.passwordKeysAlgo = passwordKeysAlgo;
    }

    public static KeyStoreConfigBuilder builder() {
        return new KeyStoreConfigBuilder();
    }

    public KeyStoreConfigBuilder toBuilder() {
        return new KeyStoreConfigBuilder().type(this.type).encryptionAlgo(this.encryptionAlgo).pbkdf(this.pbkdf).macAlgo(this.macAlgo).passwordKeysAlgo(this.passwordKeysAlgo);
    }

    public String getType() {
        return this.type;
    }

    public String getEncryptionAlgo() {
        return this.encryptionAlgo;
    }

    public PBKDF getPbkdf() {
        return this.pbkdf;
    }

    public String getMacAlgo() {
        return this.macAlgo;
    }

    public String getPasswordKeysAlgo() {
        return this.passwordKeysAlgo;
    }

    public static class KeyStoreConfigBuilder {
        private boolean type$set;
        private String type$value;
        private boolean encryptionAlgo$set;
        private String encryptionAlgo$value;
        private boolean pbkdf$set;
        private PBKDF pbkdf$value;
        private boolean macAlgo$set;
        private String macAlgo$value;
        private boolean passwordKeysAlgo$set;
        private String passwordKeysAlgo$value;

        KeyStoreConfigBuilder() {
        }

        public KeyStoreConfigBuilder type(String type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public KeyStoreConfigBuilder encryptionAlgo(String encryptionAlgo) {
            this.encryptionAlgo$value = encryptionAlgo;
            this.encryptionAlgo$set = true;
            return this;
        }

        public KeyStoreConfigBuilder pbkdf(PBKDF pbkdf) {
            this.pbkdf$value = pbkdf;
            this.pbkdf$set = true;
            return this;
        }

        public KeyStoreConfigBuilder macAlgo(String macAlgo) {
            this.macAlgo$value = macAlgo;
            this.macAlgo$set = true;
            return this;
        }

        public KeyStoreConfigBuilder passwordKeysAlgo(String passwordKeysAlgo) {
            this.passwordKeysAlgo$value = passwordKeysAlgo;
            this.passwordKeysAlgo$set = true;
            return this;
        }

        public KeyStoreConfig build() {
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = KeyStoreConfig.$default$type();
            }
            String encryptionAlgo$value = this.encryptionAlgo$value;
            if (!this.encryptionAlgo$set) {
                encryptionAlgo$value = KeyStoreConfig.$default$encryptionAlgo();
            }
            PBKDF pbkdf$value = this.pbkdf$value;
            if (!this.pbkdf$set) {
                pbkdf$value = KeyStoreConfig.$default$pbkdf();
            }
            String macAlgo$value = this.macAlgo$value;
            if (!this.macAlgo$set) {
                macAlgo$value = KeyStoreConfig.$default$macAlgo();
            }
            String passwordKeysAlgo$value = this.passwordKeysAlgo$value;
            if (!this.passwordKeysAlgo$set) {
                passwordKeysAlgo$value = KeyStoreConfig.$default$passwordKeysAlgo();
            }
            return new KeyStoreConfig(type$value, encryptionAlgo$value, pbkdf$value, macAlgo$value, passwordKeysAlgo$value);
        }

        public String toString() {
            return "KeyStoreConfig.KeyStoreConfigBuilder(type$value=" + this.type$value + ", encryptionAlgo$value=" + this.encryptionAlgo$value + ", pbkdf$value=" + this.pbkdf$value + ", macAlgo$value=" + this.macAlgo$value + ", passwordKeysAlgo$value=" + this.passwordKeysAlgo$value + ")";
        }
    }

    public static class PBKDF {
        private final PBKDF2 pbkdf2;
        private final Scrypt scrypt;

        public PBKDF(PBKDF2 pbkdf2, Scrypt scrypt) {
            if (null != pbkdf2 && null != scrypt) {
                throw new IllegalArgumentException("Ambiguous PBKDF - both scrypt and pbkdf2 are set");
            }
            if (null == pbkdf2 && null == scrypt) {
                pbkdf2 = PBKDF2.builder().build();
            }
            this.pbkdf2 = pbkdf2;
            this.scrypt = scrypt;
        }

        public static PBKDFBuilder builder() {
            return new PBKDFBuilder();
        }

        public PBKDF2 getPbkdf2() {
            return this.pbkdf2;
        }

        public Scrypt getScrypt() {
            return this.scrypt;
        }

        public static class PBKDFBuilder {
            private PBKDF2 pbkdf2;
            private Scrypt scrypt;

            PBKDFBuilder() {
            }

            public PBKDFBuilder pbkdf2(PBKDF2 pbkdf2) {
                this.pbkdf2 = pbkdf2;
                return this;
            }

            public PBKDFBuilder scrypt(Scrypt scrypt) {
                this.scrypt = scrypt;
                return this;
            }

            public PBKDF build() {
                return new PBKDF(this.pbkdf2, this.scrypt);
            }

            public String toString() {
                return "KeyStoreConfig.PBKDF.PBKDFBuilder(pbkdf2=" + this.pbkdf2 + ", scrypt=" + this.scrypt + ")";
            }
        }
    }
}

