/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.config.keystore.pbkdf;

public class Scrypt {
    private final int cost;
    private final int blockSize;
    private final int parallelization;
    private final int saltLength;

    Scrypt(int cost, int blockSize, int parallelization, int saltLength) {
        this.cost = cost;
        this.blockSize = blockSize;
        this.parallelization = parallelization;
        this.saltLength = saltLength;
    }

    public static ScryptBuilder builder() {
        return new ScryptBuilder();
    }

    public int getCost() {
        return this.cost;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getParallelization() {
        return this.parallelization;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public static class ScryptBuilder {
        private int cost;
        private int blockSize;
        private int parallelization;
        private int saltLength;

        ScryptBuilder() {
        }

        public ScryptBuilder cost(int cost) {
            this.cost = cost;
            return this;
        }

        public ScryptBuilder blockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public ScryptBuilder parallelization(int parallelization) {
            this.parallelization = parallelization;
            return this;
        }

        public ScryptBuilder saltLength(int saltLength) {
            this.saltLength = saltLength;
            return this;
        }

        public Scrypt build() {
            return new Scrypt(this.cost, this.blockSize, this.parallelization, this.saltLength);
        }

        public String toString() {
            return "Scrypt.ScryptBuilder(cost=" + this.cost + ", blockSize=" + this.blockSize + ", parallelization=" + this.parallelization + ", saltLength=" + this.saltLength + ")";
        }
    }
}

