/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types;

import com.google.common.collect.Iterables;
import de.adorsys.keymanagement.api.types.util.ShuffleUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;

public class ResultCollection<T>
implements Collection<T> {
    protected final Set<T> result;

    public ResultCollection(Set<T> result) {
        this.result = result;
    }

    public ResultCollection(List<T> result) {
        this.result = new LinkedHashSet<T>(result);
    }

    public ResultCollection<T> pickNrandom(int count) {
        return ShuffleUtil.shuffleAndSelectN(this.result, count);
    }

    public T first() {
        return (T)Iterables.getFirst(this.result, null);
    }

    public T last() {
        return (T)Iterables.getLast(this.result, null);
    }

    public ResultCollection<T> shuffle() {
        return this.pickNrandom(this.result.size());
    }

    @Override
    public int size() {
        return this.result.size();
    }

    @Override
    public boolean isEmpty() {
        return this.result.isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.result.contains(arg0);
    }

    @Override
    public Iterator<T> iterator() {
        return this.result.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.result.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.result.toArray(arg0);
    }

    @Override
    public boolean add(T arg0) {
        return this.result.add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.result.remove(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.result.containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        return this.result.addAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.result.retainAll(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.result.removeAll(arg0);
    }

    @Override
    public void clear() {
        this.result.clear();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.result.spliterator();
    }
}

