/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template;

import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.KeyNamingStrategy;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import java.util.function.Supplier;
import lombok.NonNull;

public class NameAndPassword
implements KeyTemplate {
    @NonNull
    private final KeyNamingStrategy namingStrategy;
    private final Supplier<char[]> password;

    public NameAndPassword(String alias, @NonNull Supplier<char[]> password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.namingStrategy = new DefaultNamingStrategy(alias, null);
        this.password = password;
    }

    public NameAndPassword(@NonNull Supplier<char[]> password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.namingStrategy = new DefaultNamingStrategy(null, null);
        this.password = password;
    }

    @Override
    public String generateName() {
        return this.namingStrategy.generateName();
    }

    @NonNull
    public KeyNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public Supplier<char[]> getPassword() {
        return this.password;
    }

    public NameAndPassword(@NonNull KeyNamingStrategy namingStrategy, Supplier<char[]> password) {
        if (namingStrategy == null) {
            throw new NullPointerException("namingStrategy is marked non-null but is null");
        }
        this.namingStrategy = namingStrategy;
        this.password = password;
    }
}

