/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

public class KeyPairEncryptionTemplate {
    private final String algo;
    private final int size;
    private final String sigAlgo;
    private final String commonName;

    static KeyPairEncryptionTemplate of(String algo, Integer size, String sigAlgo, String commonName) {
        KeyPairEncryptionTemplate result = KeyPairEncryptionTemplate.builder().build();
        if (null != algo) {
            result = result.toBuilder().algo(algo).build();
        }
        if (null != size) {
            result = result.toBuilder().size(size).build();
        }
        if (null != sigAlgo) {
            result = result.toBuilder().sigAlgo(sigAlgo).build();
        }
        if (null != commonName) {
            result = result.toBuilder().commonName(commonName).build();
        }
        return result;
    }

    private static String $default$algo() {
        return "RSA";
    }

    private static int $default$size() {
        return 2048;
    }

    private static String $default$sigAlgo() {
        return "SHA256withRSA";
    }

    private static String $default$commonName() {
        return "KEY-PAIR";
    }

    KeyPairEncryptionTemplate(String algo, int size, String sigAlgo, String commonName) {
        this.algo = algo;
        this.size = size;
        this.sigAlgo = sigAlgo;
        this.commonName = commonName;
    }

    public static KeyPairEncryptionTemplateBuilder builder() {
        return new KeyPairEncryptionTemplateBuilder();
    }

    public KeyPairEncryptionTemplateBuilder toBuilder() {
        return new KeyPairEncryptionTemplateBuilder().algo(this.algo).size(this.size).sigAlgo(this.sigAlgo).commonName(this.commonName);
    }

    public String getAlgo() {
        return this.algo;
    }

    public int getSize() {
        return this.size;
    }

    public String getSigAlgo() {
        return this.sigAlgo;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public static class KeyPairEncryptionTemplateBuilder {
        private boolean algo$set;
        private String algo$value;
        private boolean size$set;
        private int size$value;
        private boolean sigAlgo$set;
        private String sigAlgo$value;
        private boolean commonName$set;
        private String commonName$value;

        KeyPairEncryptionTemplateBuilder() {
        }

        public KeyPairEncryptionTemplateBuilder algo(String algo) {
            this.algo$value = algo;
            this.algo$set = true;
            return this;
        }

        public KeyPairEncryptionTemplateBuilder size(int size) {
            this.size$value = size;
            this.size$set = true;
            return this;
        }

        public KeyPairEncryptionTemplateBuilder sigAlgo(String sigAlgo) {
            this.sigAlgo$value = sigAlgo;
            this.sigAlgo$set = true;
            return this;
        }

        public KeyPairEncryptionTemplateBuilder commonName(String commonName) {
            this.commonName$value = commonName;
            this.commonName$set = true;
            return this;
        }

        public KeyPairEncryptionTemplate build() {
            String algo$value = this.algo$value;
            if (!this.algo$set) {
                algo$value = KeyPairEncryptionTemplate.$default$algo();
            }
            int size$value = this.size$value;
            if (!this.size$set) {
                size$value = KeyPairEncryptionTemplate.$default$size();
            }
            String sigAlgo$value = this.sigAlgo$value;
            if (!this.sigAlgo$set) {
                sigAlgo$value = KeyPairEncryptionTemplate.$default$sigAlgo();
            }
            String commonName$value = this.commonName$value;
            if (!this.commonName$set) {
                commonName$value = KeyPairEncryptionTemplate.$default$commonName();
            }
            return new KeyPairEncryptionTemplate(algo$value, size$value, sigAlgo$value, commonName$value);
        }

        public String toString() {
            return "KeyPairEncryptionTemplate.KeyPairEncryptionTemplateBuilder(algo$value=" + this.algo$value + ", size$value=" + this.size$value + ", sigAlgo$value=" + this.sigAlgo$value + ", commonName$value=" + this.commonName$value + ")";
        }
    }

    public static interface ExcludeToBuilder {
        public KeyPairEncryptionTemplate toBuilder();
    }
}

