/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.provided;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import java.security.KeyStore;
import java.util.Set;
import java.util.function.Supplier;
import lombok.NonNull;

public class ProvidedKeyEntry
implements ProvidedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final KeyStore.Entry entry;
    private final KeyMetadata metadata;

    ProvidedKeyEntry(@NonNull KeyTemplate keyTemplate, @NonNull KeyStore.Entry entry, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.entry = entry;
    }

    ProvidedKeyEntry(String alias, String prefix, Supplier<char[]> password, @NonNull KeyStore.Entry entry, KeyMetadata metadata) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.entry = entry;
    }

    public static Templated builder() {
        return new Templated();
    }

    public Templated toBuilder() {
        return new Templated().keyTemplate(this.keyTemplate).entry(this.entry).metadata(this.metadata);
    }

    public static ProvidedKeyEntryBuilder with() {
        return new ProvidedKeyEntryBuilder();
    }

    @NonNull
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    public KeyStore.Entry getEntry() {
        return this.entry;
    }

    @Override
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    public Set<KeyStore.Entry.Attribute> getAttributes() {
        return this.getEntry().getAttributes();
    }

    public static class ProvidedKeyEntryBuilder {
        private String alias;
        private String prefix;
        private Supplier<char[]> password;
        private KeyStore.Entry entry;
        private KeyMetadata metadata;

        ProvidedKeyEntryBuilder() {
        }

        public ProvidedKeyEntryBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public ProvidedKeyEntryBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public ProvidedKeyEntryBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        public ProvidedKeyEntryBuilder entry(@NonNull KeyStore.Entry entry) {
            if (entry == null) {
                throw new NullPointerException("entry is marked non-null but is null");
            }
            this.entry = entry;
            return this;
        }

        public ProvidedKeyEntryBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ProvidedKeyEntry build() {
            return new ProvidedKeyEntry(this.alias, this.prefix, this.password, this.entry, this.metadata);
        }

        public String toString() {
            return "ProvidedKeyEntry.ProvidedKeyEntryBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", entry=" + this.entry + ", metadata=" + this.metadata + ")";
        }
    }

    public static class Templated {
        private KeyTemplate keyTemplate;
        private KeyStore.Entry entry;
        private KeyMetadata metadata;

        Templated() {
        }

        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        public Templated entry(@NonNull KeyStore.Entry entry) {
            if (entry == null) {
                throw new NullPointerException("entry is marked non-null but is null");
            }
            this.entry = entry;
            return this;
        }

        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ProvidedKeyEntry build() {
            return new ProvidedKeyEntry(this.keyTemplate, this.entry, this.metadata);
        }

        public String toString() {
            return "ProvidedKeyEntry.Templated(keyTemplate=" + this.keyTemplate + ", entry=" + this.entry + ", metadata=" + this.metadata + ")";
        }
    }
}

