/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types;

import com.google.common.collect.Iterables;
import de.adorsys.keymanagement.api.types.util.ShuffleUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.Generated;

public class ResultCollection<T>
implements Collection<T> {
    protected final Set<T> result;

    public ResultCollection(Set<T> result) {
        this.result = result;
    }

    public ResultCollection(List<T> result) {
        this.result = new LinkedHashSet<T>(result);
    }

    public ResultCollection<T> pickNrandom(int count) {
        return ShuffleUtil.shuffleAndSelectN(this.result, count);
    }

    public T first() {
        return (T)Iterables.getFirst(this.result, null);
    }

    public T last() {
        return (T)Iterables.getLast(this.result, null);
    }

    public ResultCollection<T> shuffle() {
        return this.pickNrandom(this.result.size());
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int size() {
        return this.result.size();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEmpty() {
        return this.result.isEmpty();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean contains(Object arg0) {
        return this.result.contains(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Iterator<T> iterator() {
        return this.result.iterator();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object[] toArray() {
        return this.result.toArray();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public <T> T[] toArray(T[] arg0) {
        return this.result.toArray(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean add(T arg0) {
        return this.result.add(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean remove(Object arg0) {
        return this.result.remove(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean containsAll(Collection<?> arg0) {
        return this.result.containsAll(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean addAll(Collection<? extends T> arg0) {
        return this.result.addAll(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean retainAll(Collection<?> arg0) {
        return this.result.retainAll(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean removeAll(Collection<?> arg0) {
        return this.result.removeAll(arg0);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void clear() {
        this.result.clear();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Spliterator<T> spliterator() {
        return this.result.spliterator();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.result.toArray(generator);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean removeIf(Predicate<? super T> filter) {
        return this.result.removeIf(filter);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Stream<T> stream() {
        return this.result.stream();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Stream<T> parallelStream() {
        return this.result.parallelStream();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void forEach(Consumer<? super T> action) {
        this.result.forEach(action);
    }
}

