/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.generated.SecretKeyEncryptionTemplate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;

public class Secret
implements GeneratedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final SecretKeyEncryptionTemplate encryptionTemplate;
    private final KeyMetadata metadata;

    public Collection<Secret> repeat(int times) {
        return IntStream.range(0, times).boxed().map(it -> this.toBuilder().build()).collect(Collectors.toList());
    }

    Secret(@NonNull KeyTemplate keyTemplate, @NonNull SecretKeyEncryptionTemplate encryptionTemplate, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (encryptionTemplate == null) {
            throw new NullPointerException("encryptionTemplate is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.encryptionTemplate = encryptionTemplate;
    }

    Secret(String alias, String prefix, Supplier<char[]> password, String algo, Integer keySize, KeyMetadata metadata) {
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.encryptionTemplate = SecretKeyEncryptionTemplate.of(algo, keySize);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static Templated builder() {
        return new Templated();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Templated toBuilder() {
        return new Templated().keyTemplate(this.keyTemplate).encryptionTemplate(this.encryptionTemplate).metadata(this.metadata);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SecretBuilder with() {
        return new SecretBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SecretKeyEncryptionTemplate getEncryptionTemplate() {
        return this.encryptionTemplate;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAlgo() {
        return this.getEncryptionTemplate().getAlgo();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSize() {
        return this.getEncryptionTemplate().getSize();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class Templated {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyTemplate keyTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SecretKeyEncryptionTemplate encryptionTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Templated() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated encryptionTemplate(@NonNull SecretKeyEncryptionTemplate encryptionTemplate) {
            if (encryptionTemplate == null) {
                throw new NullPointerException("encryptionTemplate is marked non-null but is null");
            }
            this.encryptionTemplate = encryptionTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Secret build() {
            return new Secret(this.keyTemplate, this.encryptionTemplate, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Secret.Templated(keyTemplate=" + String.valueOf(this.keyTemplate) + ", encryptionTemplate=" + String.valueOf(this.encryptionTemplate) + ", metadata=" + String.valueOf(this.metadata) + ")";
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SecretBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String alias;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String prefix;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Supplier<char[]> password;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String algo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer keySize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SecretBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SecretBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SecretBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SecretBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SecretBuilder algo(String algo) {
            this.algo = algo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SecretBuilder keySize(Integer keySize) {
            this.keySize = keySize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SecretBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Secret build() {
            return new Secret(this.alias, this.prefix, this.password, this.algo, this.keySize, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Secret.SecretBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + String.valueOf(this.password) + ", algo=" + this.algo + ", keySize=" + this.keySize + ", metadata=" + String.valueOf(this.metadata) + ")";
        }
    }
}

