/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.provided;

import de.adorsys.keymanagement.api.types.entity.KeyPairEntry;
import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;

public class ProvidedKeyPair
implements ProvidedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final KeyPair pair;
    private final KeyMetadata metadata;
    @NonNull
    private final List<Certificate> certificates;

    ProvidedKeyPair(@NonNull KeyTemplate keyTemplate, @NonNull KeyPair pair, @NonNull List<Certificate> certificates, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        if (certificates == null) {
            throw new NullPointerException("certificates is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.certificates = certificates;
        this.pair = pair;
    }

    ProvidedKeyPair(String alias, String prefix, Supplier<char[]> password, @NonNull KeyPair pair, @NonNull List<Certificate> certificates, KeyMetadata metadata) {
        if (pair == null) {
            throw new NullPointerException("pair is marked non-null but is null");
        }
        if (certificates == null) {
            throw new NullPointerException("certificates is marked non-null but is null");
        }
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.certificates = certificates;
        this.pair = pair;
    }

    public static ProvidedKeyPair from(KeyPairEntry entry, GeneratedKeyTemplate template) {
        return ProvidedKeyPair.builder().keyTemplate(template).pair(entry.getPair()).metadata(template.getMetadata()).certificates(entry.getCertificates()).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static Templated builder() {
        return new Templated();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Templated toBuilder() {
        Templated builder = new Templated().keyTemplate(this.keyTemplate).pair(this.pair).metadata(this.metadata);
        if (this.certificates != null) {
            builder.certificates(this.certificates);
        }
        return builder;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ProvidedKeyPairBuilder with() {
        return new ProvidedKeyPairBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyPair getPair() {
        return this.pair;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PublicKey getPublic() {
        return this.getPair().getPublic();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PrivateKey getPrivate() {
        return this.getPair().getPrivate();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class Templated {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyTemplate keyTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyPair pair;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Certificate> certificates;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Templated() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated pair(@NonNull KeyPair pair) {
            if (pair == null) {
                throw new NullPointerException("pair is marked non-null but is null");
            }
            this.pair = pair;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated certificate(Certificate certificate) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.add(certificate);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated certificates(Collection<? extends Certificate> certificates) {
            if (certificates == null) {
                throw new NullPointerException("certificates cannot be null");
            }
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.addAll(certificates);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated clearCertificates() {
            if (this.certificates != null) {
                this.certificates.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPair build() {
            return new ProvidedKeyPair(this.keyTemplate, this.pair, switch (this.certificates == null ? 0 : this.certificates.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.certificates.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Certificate>(this.certificates));
            }, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ProvidedKeyPair.Templated(keyTemplate=" + String.valueOf(this.keyTemplate) + ", pair=" + String.valueOf(this.pair) + ", certificates=" + String.valueOf(this.certificates) + ", metadata=" + String.valueOf(this.metadata) + ")";
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ProvidedKeyPairBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String alias;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String prefix;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Supplier<char[]> password;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyPair pair;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ArrayList<Certificate> certificates;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ProvidedKeyPairBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder pair(@NonNull KeyPair pair) {
            if (pair == null) {
                throw new NullPointerException("pair is marked non-null but is null");
            }
            this.pair = pair;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder certificate(Certificate certificate) {
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.add(certificate);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder certificates(Collection<? extends Certificate> certificates) {
            if (certificates == null) {
                throw new NullPointerException("certificates cannot be null");
            }
            if (this.certificates == null) {
                this.certificates = new ArrayList();
            }
            this.certificates.addAll(certificates);
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder clearCertificates() {
            if (this.certificates != null) {
                this.certificates.clear();
            }
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPairBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyPair build() {
            return new ProvidedKeyPair(this.alias, this.prefix, this.password, this.pair, switch (this.certificates == null ? 0 : this.certificates.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.certificates.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Certificate>(this.certificates));
            }, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ProvidedKeyPair.ProvidedKeyPairBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + String.valueOf(this.password) + ", pair=" + String.valueOf(this.pair) + ", certificates=" + String.valueOf(this.certificates) + ", metadata=" + String.valueOf(this.metadata) + ")";
        }
    }
}

