/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.generated;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.GeneratedKeyTemplate;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.generated.KeyPairEncryptionTemplate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;

public class Signing
implements GeneratedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final KeyPairEncryptionTemplate encryptionTemplate;
    private final KeyMetadata metadata;

    public Collection<Signing> repeat(int times) {
        return IntStream.range(0, times).boxed().map(it -> this.toBuilder().build()).collect(Collectors.toList());
    }

    Signing(@NonNull KeyTemplate keyTemplate, @NonNull KeyPairEncryptionTemplate encryptionTemplate, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (encryptionTemplate == null) {
            throw new NullPointerException("encryptionTemplate is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.encryptionTemplate = encryptionTemplate;
    }

    Signing(String alias, String prefix, Supplier<char[]> password, String algo, String sigAlgo, Integer keySize, KeyMetadata metadata, String commonName) {
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.encryptionTemplate = KeyPairEncryptionTemplate.of(algo, keySize, sigAlgo, commonName);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static Templated builder() {
        return new Templated();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Templated toBuilder() {
        return new Templated().keyTemplate(this.keyTemplate).encryptionTemplate(this.encryptionTemplate).metadata(this.metadata);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SigningBuilder with() {
        return new SigningBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyPairEncryptionTemplate getEncryptionTemplate() {
        return this.encryptionTemplate;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAlgo() {
        return this.getEncryptionTemplate().getAlgo();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSize() {
        return this.getEncryptionTemplate().getSize();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSigAlgo() {
        return this.getEncryptionTemplate().getSigAlgo();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCommonName() {
        return this.getEncryptionTemplate().getCommonName();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class Templated {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyTemplate keyTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyPairEncryptionTemplate encryptionTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Templated() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated encryptionTemplate(@NonNull KeyPairEncryptionTemplate encryptionTemplate) {
            if (encryptionTemplate == null) {
                throw new NullPointerException("encryptionTemplate is marked non-null but is null");
            }
            this.encryptionTemplate = encryptionTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Signing build() {
            return new Signing(this.keyTemplate, this.encryptionTemplate, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Signing.Templated(keyTemplate=" + this.keyTemplate + ", encryptionTemplate=" + this.encryptionTemplate + ", metadata=" + this.metadata + ")";
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SigningBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String alias;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String prefix;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Supplier<char[]> password;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String algo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String sigAlgo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer keySize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String commonName;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SigningBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder algo(String algo) {
            this.algo = algo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder sigAlgo(String sigAlgo) {
            this.sigAlgo = sigAlgo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder keySize(Integer keySize) {
            this.keySize = keySize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SigningBuilder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Signing build() {
            return new Signing(this.alias, this.prefix, this.password, this.algo, this.sigAlgo, this.keySize, this.metadata, this.commonName);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Signing.SigningBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", algo=" + this.algo + ", sigAlgo=" + this.sigAlgo + ", keySize=" + this.keySize + ", metadata=" + this.metadata + ", commonName=" + this.commonName + ")";
        }
    }
}

