/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.api.types.template.provided;

import de.adorsys.keymanagement.api.types.entity.metadata.KeyMetadata;
import de.adorsys.keymanagement.api.types.template.DefaultNamingStrategy;
import de.adorsys.keymanagement.api.types.template.KeyTemplate;
import de.adorsys.keymanagement.api.types.template.NameAndPassword;
import de.adorsys.keymanagement.api.types.template.ProvidedKeyTemplate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyStore;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;

public class ProvidedKeyEntry
implements ProvidedKeyTemplate {
    @NonNull
    private final KeyTemplate keyTemplate;
    @NonNull
    private final KeyStore.Entry entry;
    private final KeyMetadata metadata;

    ProvidedKeyEntry(@NonNull KeyTemplate keyTemplate, @NonNull KeyStore.Entry entry, KeyMetadata metadata) {
        if (keyTemplate == null) {
            throw new NullPointerException("keyTemplate is marked non-null but is null");
        }
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.keyTemplate = keyTemplate;
        this.metadata = metadata;
        this.entry = entry;
    }

    ProvidedKeyEntry(String alias, String prefix, Supplier<char[]> password, @NonNull KeyStore.Entry entry, KeyMetadata metadata) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        this.keyTemplate = new NameAndPassword(new DefaultNamingStrategy(alias, prefix), password);
        this.metadata = metadata;
        this.entry = entry;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static Templated builder() {
        return new Templated();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Templated toBuilder() {
        return new Templated().keyTemplate(this.keyTemplate).entry(this.entry).metadata(this.metadata);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ProvidedKeyEntryBuilder with() {
        return new ProvidedKeyEntryBuilder();
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyTemplate getKeyTemplate() {
        return this.keyTemplate;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyStore.Entry getEntry() {
        return this.entry;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String generateName() {
        return this.getKeyTemplate().generateName();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Supplier<char[]> getPassword() {
        return this.getKeyTemplate().getPassword();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<KeyStore.Entry.Attribute> getAttributes() {
        return this.getEntry().getAttributes();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class Templated {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyTemplate keyTemplate;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyStore.Entry entry;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        Templated() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated keyTemplate(@NonNull KeyTemplate keyTemplate) {
            if (keyTemplate == null) {
                throw new NullPointerException("keyTemplate is marked non-null but is null");
            }
            this.keyTemplate = keyTemplate;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated entry(@NonNull KeyStore.Entry entry) {
            if (entry == null) {
                throw new NullPointerException("entry is marked non-null but is null");
            }
            this.entry = entry;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Templated metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyEntry build() {
            return new ProvidedKeyEntry(this.keyTemplate, this.entry, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ProvidedKeyEntry.Templated(keyTemplate=" + this.keyTemplate + ", entry=" + this.entry + ", metadata=" + this.metadata + ")";
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ProvidedKeyEntryBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String alias;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String prefix;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Supplier<char[]> password;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyStore.Entry entry;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private KeyMetadata metadata;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ProvidedKeyEntryBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyEntryBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyEntryBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyEntryBuilder password(Supplier<char[]> password) {
            this.password = password;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyEntryBuilder entry(@NonNull KeyStore.Entry entry) {
            if (entry == null) {
                throw new NullPointerException("entry is marked non-null but is null");
            }
            this.entry = entry;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyEntryBuilder metadata(KeyMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ProvidedKeyEntry build() {
            return new ProvidedKeyEntry(this.alias, this.prefix, this.password, this.entry, this.metadata);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ProvidedKeyEntry.ProvidedKeyEntryBuilder(alias=" + this.alias + ", prefix=" + this.prefix + ", password=" + this.password + ", entry=" + this.entry + ", metadata=" + this.metadata + ")";
        }
    }
}

