/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator;

import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyPairBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.KeyPairData;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.generator.SingleKeyUsageSelfSignedCertBuilder;
import de.adorsys.keymanagement.bouncycastle.adapter.services.deprecated.types.SelfSignedKeyPairData;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.KeyPair;
import java.security.Provider;
import lombok.Generated;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class KeyPairGenerator {
    private static final int[] KEY_USAGE_SIGNATURE = new int[]{64};
    private static final int[] KEY_USAGE_ENCRYPTION = new int[]{32, 16, 8};
    private final Provider provider;
    private final String keyAlgo;
    private final int keySize;
    private final String serverSigAlgo;
    private final String serverKeyPairName;
    private final int daysAfter;
    private final boolean withCA;

    public KeyPairData generateSignatureKey() {
        return this.generate(KEY_USAGE_SIGNATURE);
    }

    public KeyPairData generateEncryptionKey() {
        return this.generate(KEY_USAGE_ENCRYPTION);
    }

    private KeyPairData generate(int[] keyUsages) {
        KeyPair keyPair = new KeyPairBuilder().withProvider(this.provider).withKeyAlg(this.keyAlgo).withKeyLength(this.keySize).build();
        X500Name dn = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, this.serverKeyPairName).build();
        SelfSignedKeyPairData keyPairData = new SingleKeyUsageSelfSignedCertBuilder().withProvider(this.provider).withSubjectDN(dn).withSignatureAlgo(this.serverSigAlgo).withNotAfterInDays(this.daysAfter).withCa(this.withCA).withKeyUsages(keyUsages).build(keyPair);
        return KeyPairData.builder().keyPair(keyPairData).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static int $default$daysAfter() {
        return 900;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static boolean $default$withCA() {
        return false;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    KeyPairGenerator(Provider provider, String keyAlgo, int keySize, String serverSigAlgo, String serverKeyPairName, int daysAfter, boolean withCA) {
        this.provider = provider;
        this.keyAlgo = keyAlgo;
        this.keySize = keySize;
        this.serverSigAlgo = serverSigAlgo;
        this.serverKeyPairName = serverKeyPairName;
        this.daysAfter = daysAfter;
        this.withCA = withCA;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static KeyPairGeneratorBuilder builder() {
        return new KeyPairGeneratorBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class KeyPairGeneratorBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Provider provider;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String keyAlgo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int keySize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serverSigAlgo;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serverKeyPairName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean daysAfter$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int daysAfter$value;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean withCA$set;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private boolean withCA$value;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        KeyPairGeneratorBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGeneratorBuilder provider(Provider provider) {
            this.provider = provider;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGeneratorBuilder keyAlgo(String keyAlgo) {
            this.keyAlgo = keyAlgo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGeneratorBuilder keySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGeneratorBuilder serverSigAlgo(String serverSigAlgo) {
            this.serverSigAlgo = serverSigAlgo;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGeneratorBuilder serverKeyPairName(String serverKeyPairName) {
            this.serverKeyPairName = serverKeyPairName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGeneratorBuilder daysAfter(int daysAfter) {
            this.daysAfter$value = daysAfter;
            this.daysAfter$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGeneratorBuilder withCA(boolean withCA) {
            this.withCA$value = withCA;
            this.withCA$set = true;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public KeyPairGenerator build() {
            int daysAfter$value = this.daysAfter$value;
            if (!this.daysAfter$set) {
                daysAfter$value = KeyPairGenerator.$default$daysAfter();
            }
            boolean withCA$value = this.withCA$value;
            if (!this.withCA$set) {
                withCA$value = KeyPairGenerator.$default$withCA();
            }
            return new KeyPairGenerator(this.provider, this.keyAlgo, this.keySize, this.serverSigAlgo, this.serverKeyPairName, daysAfter$value, withCA$value);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "KeyPairGenerator.KeyPairGeneratorBuilder(provider=" + this.provider + ", keyAlgo=" + this.keyAlgo + ", keySize=" + this.keySize + ", serverSigAlgo=" + this.serverSigAlgo + ", serverKeyPairName=" + this.serverKeyPairName + ", daysAfter$value=" + this.daysAfter$value + ", withCA$value=" + this.withCA$value + ")";
        }
    }
}

