/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.keymanagement.juggler.services;

import dagger.Lazy;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import de.adorsys.keymanagement.adapter.modules.generator.GeneratorModule_ProviderFactory;
import de.adorsys.keymanagement.api.config.keystore.KeyStoreConfig;
import de.adorsys.keymanagement.api.generator.EncryptingKeyGenerator;
import de.adorsys.keymanagement.api.generator.KeyGenerator;
import de.adorsys.keymanagement.api.generator.SecretKeyGenerator;
import de.adorsys.keymanagement.api.generator.SigningKeyGenerator;
import de.adorsys.keymanagement.api.keystore.KeyStoreOper;
import de.adorsys.keymanagement.api.metadata.KeyMetadataOper;
import de.adorsys.keymanagement.api.metadata.KeyMetadataPersistence;
import de.adorsys.keymanagement.api.persist.KeyStoreCreator;
import de.adorsys.keymanagement.api.persist.SerDe;
import de.adorsys.keymanagement.api.source.KeyDecoder;
import de.adorsys.keymanagement.api.source.KeyReader;
import de.adorsys.keymanagement.bouncycastle.adapter.services.decode.DefaultDecoderImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.decode.DefaultDecoderImpl_Factory;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultEncryptingKeyGeneratorImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultSecretKeyGeneratorImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultSecretKeyGeneratorImpl_Factory;
import de.adorsys.keymanagement.bouncycastle.adapter.services.generator.DefaultSigningKeyGeneratorImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.persist.DefaultKeyStoreOperImpl;
import de.adorsys.keymanagement.bouncycastle.adapter.services.serde.DefaultKeyStoreSerde;
import de.adorsys.keymanagement.core.generator.TemplateMappingGeneratorImpl;
import de.adorsys.keymanagement.core.metadata.MetadataPersistenceConfig;
import de.adorsys.keymanagement.core.metadata.ToKeyStoreMetadataPersister;
import de.adorsys.keymanagement.core.metadata.ToKeyStoreMetadataPersister_Factory;
import de.adorsys.keymanagement.core.source.DefaultKeyReaderImpl;
import de.adorsys.keymanagement.juggler.modules.metadata.MetadataModule;
import de.adorsys.keymanagement.juggler.modules.metadata.MetadataModule_MetadataOperFactory;
import de.adorsys.keymanagement.juggler.services.BCJuggler;
import javax.inject.Provider;

public final class DaggerBCJuggler
implements BCJuggler {
    private final MetadataPersistenceConfig metadataConfig;
    private final KeyMetadataPersistence metadataPersister;
    private final MetadataModule metadataModule;
    private final KeyStoreConfig keyStoreConfig;
    private Provider<MetadataPersistenceConfig> metadataConfigProvider;
    private Provider<DefaultSecretKeyGeneratorImpl> defaultSecretKeyGeneratorImplProvider;
    private Provider<ToKeyStoreMetadataPersister> toKeyStoreMetadataPersisterProvider;

    private DaggerBCJuggler(MetadataModule metadataModuleParam, MetadataPersistenceConfig metadataConfigParam, KeyStoreConfig keyStoreConfigParam, KeyMetadataPersistence metadataPersisterParam) {
        this.metadataConfig = metadataConfigParam;
        this.metadataPersister = metadataPersisterParam;
        this.metadataModule = metadataModuleParam;
        this.keyStoreConfig = keyStoreConfigParam;
        this.initialize(metadataModuleParam, metadataConfigParam, keyStoreConfigParam, metadataPersisterParam);
    }

    public static BCJuggler.Builder builder() {
        return new Builder();
    }

    private DefaultEncryptingKeyGeneratorImpl getDefaultEncryptingKeyGeneratorImpl() {
        return new DefaultEncryptingKeyGeneratorImpl(GeneratorModule_ProviderFactory.provider());
    }

    private DefaultSecretKeyGeneratorImpl getDefaultSecretKeyGeneratorImpl() {
        return new DefaultSecretKeyGeneratorImpl(GeneratorModule_ProviderFactory.provider());
    }

    private DefaultSigningKeyGeneratorImpl getDefaultSigningKeyGeneratorImpl() {
        return new DefaultSigningKeyGeneratorImpl(GeneratorModule_ProviderFactory.provider());
    }

    private TemplateMappingGeneratorImpl getTemplateMappingGeneratorImpl() {
        return new TemplateMappingGeneratorImpl((EncryptingKeyGenerator)this.getDefaultEncryptingKeyGeneratorImpl(), (SecretKeyGenerator)this.getDefaultSecretKeyGeneratorImpl(), (SigningKeyGenerator)this.getDefaultSigningKeyGeneratorImpl());
    }

    private KeyMetadataOper getKeyMetadataOper() {
        return MetadataModule_MetadataOperFactory.metadataOper(this.metadataModule, this.metadataConfig, this.metadataPersister, (Lazy<ToKeyStoreMetadataPersister>)DoubleCheck.lazy(this.toKeyStoreMetadataPersisterProvider));
    }

    private DefaultKeyStoreOperImpl getDefaultKeyStoreOperImpl() {
        return new DefaultKeyStoreOperImpl(GeneratorModule_ProviderFactory.provider(), this.getKeyMetadataOper(), this.keyStoreConfig);
    }

    private DefaultKeyReaderImpl getDefaultKeyReaderImpl() {
        return new DefaultKeyReaderImpl((KeyStoreOper)this.getDefaultKeyStoreOperImpl(), this.getKeyMetadataOper());
    }

    private DefaultKeyStoreSerde getDefaultKeyStoreSerde() {
        return new DefaultKeyStoreSerde(GeneratorModule_ProviderFactory.provider(), this.keyStoreConfig);
    }

    private void initialize(MetadataModule metadataModuleParam, MetadataPersistenceConfig metadataConfigParam, KeyStoreConfig keyStoreConfigParam, KeyMetadataPersistence metadataPersisterParam) {
        this.metadataConfigProvider = InstanceFactory.createNullable((Object)metadataConfigParam);
        this.defaultSecretKeyGeneratorImplProvider = DefaultSecretKeyGeneratorImpl_Factory.create((Provider)GeneratorModule_ProviderFactory.create());
        this.toKeyStoreMetadataPersisterProvider = ToKeyStoreMetadataPersister_Factory.create(this.metadataConfigProvider, this.defaultSecretKeyGeneratorImplProvider, (Provider)DefaultDecoderImpl_Factory.create());
    }

    public KeyGenerator generateKeys() {
        return this.getTemplateMappingGeneratorImpl();
    }

    public KeyStoreCreator toKeystore() {
        return this.getDefaultKeyStoreOperImpl();
    }

    public KeyReader readKeys() {
        return this.getDefaultKeyReaderImpl();
    }

    public KeyDecoder decode() {
        return new DefaultDecoderImpl();
    }

    public SerDe serializeDeserialize() {
        return this.getDefaultKeyStoreSerde();
    }

    private static final class Builder
    implements BCJuggler.Builder {
        private MetadataPersistenceConfig metadataConfig;
        private KeyStoreConfig keyStoreConfig;
        private KeyMetadataPersistence metadataPersister;

        private Builder() {
        }

        @Override
        public Builder metadataConfig(MetadataPersistenceConfig config) {
            this.metadataConfig = config;
            return this;
        }

        @Override
        public Builder keyStoreConfig(KeyStoreConfig config) {
            this.keyStoreConfig = config;
            return this;
        }

        @Override
        public Builder metadataPersister(KeyMetadataPersistence persistence) {
            this.metadataPersister = persistence;
            return this;
        }

        @Override
        public BCJuggler build() {
            return new DaggerBCJuggler(new MetadataModule(), this.metadataConfig, this.keyStoreConfig, this.metadataPersister);
        }
    }
}

