/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.initiation;

import de.adorsys.ledgers.app.initiation.PaymentRestInitiationService;
import de.adorsys.ledgers.app.mock.AccountBalance;
import de.adorsys.ledgers.app.mock.BulkPaymentsData;
import de.adorsys.ledgers.app.mock.MockbankInitData;
import de.adorsys.ledgers.app.mock.SinglePaymentsData;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountInitService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountTransactionService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.service.CurrencyService;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import de.adorsys.ledgers.util.exception.UserManagementModuleException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BankInitService {
    private final Logger logger = LoggerFactory.getLogger(BankInitService.class);
    private final MockbankInitData mockbankInitData;
    private final UserService userService;
    private final UserMapper userMapper;
    private final DepositAccountInitService depositAccountInitService;
    private final DepositAccountService depositAccountService;
    private final DepositAccountTransactionService transactionService;
    private final AccountDetailsMapper accountDetailsMapper;
    private final PaymentRestInitiationService restInitiationService;
    private final CurrencyService currencyService;
    private static final String ACCOUNT_NOT_FOUND_MSG = "Account not Found! Should never happen while initiating mock data!";
    private static final String NO_USER_BY_IBAN = "Could not get User By Iban {}";
    private static final LocalDateTime START_DATE = LocalDateTime.of(2018, 1, 1, 1, 1);

    @Autowired
    public BankInitService(MockbankInitData mockbankInitData, UserService userService, UserMapper userMapper, DepositAccountInitService depositAccountInitService, DepositAccountService depositAccountService, DepositAccountTransactionService transactionService, AccountDetailsMapper accountDetailsMapper, PaymentRestInitiationService restInitiationService, CurrencyService currencyService) {
        this.mockbankInitData = mockbankInitData;
        this.userService = userService;
        this.userMapper = userMapper;
        this.depositAccountInitService = depositAccountInitService;
        this.depositAccountService = depositAccountService;
        this.transactionService = transactionService;
        this.accountDetailsMapper = accountDetailsMapper;
        this.restInitiationService = restInitiationService;
        this.currencyService = currencyService;
    }

    public void init() {
        this.depositAccountInitService.initConfigData();
        this.createAdmin();
    }

    public void uploadTestData() {
        this.createUsers();
        this.createAccounts();
        this.performTransactions();
    }

    private void createAdmin() {
        try {
            this.userService.findByLogin("admin");
            this.logger.info("Admin user is already present. Skipping creation");
        }
        catch (UserManagementModuleException e) {
            UserTO admin = new UserTO("admin", "admin@mail.de", "admin123");
            admin.setUserRoles(Collections.singleton(UserRoleTO.SYSTEM));
            this.createUser(admin);
        }
    }

    private void performTransactions() {
        List users = this.mockbankInitData.getUsers();
        this.performSinglePayments(users);
        this.performBulkPayments(users);
    }

    private void performSinglePayments(List<UserTO> users) {
        for (SinglePaymentsData paymentsData : this.mockbankInitData.getSinglePayments()) {
            PaymentTO payment = paymentsData.getSinglePayment();
            try {
                if (!this.isAbsentTransactionRegular(payment.getDebtorAccount().getIban(), payment.getDebtorAccount().getCurrency(), ((PaymentTargetTO)payment.getTargets().get(0)).getEndToEndIdentification())) continue;
                UserTO user = this.getUserByIban(users, payment.getDebtorAccount().getIban());
                this.restInitiationService.executePayment(user, PaymentTypeTO.SINGLE, payment);
            }
            catch (DepositModuleException e) {
                this.logger.error(ACCOUNT_NOT_FOUND_MSG);
            }
            catch (UserManagementModuleException e) {
                this.logger.error(NO_USER_BY_IBAN, (Object)payment.getDebtorAccount().getIban());
            }
        }
    }

    private void performBulkPayments(List<UserTO> users) {
        for (BulkPaymentsData paymentsData : this.mockbankInitData.getBulkPayments()) {
            PaymentTO payment = paymentsData.getBulkPayment();
            AccountReferenceTO debtorAccount = payment.getDebtorAccount();
            try {
                boolean isAbsentTransaction = Optional.ofNullable(payment.getBatchBookingPreferred()).orElse(false) != false ? this.isAbsentTransactionBatch(payment) : this.isAbsentTransactionRegular(debtorAccount.getIban(), debtorAccount.getCurrency(), ((PaymentTargetTO)payment.getTargets().iterator().next()).getEndToEndIdentification());
                if (!isAbsentTransaction) continue;
                UserTO user = this.getUserByIban(users, debtorAccount.getIban());
                this.restInitiationService.executePayment(user, PaymentTypeTO.BULK, payment);
            }
            catch (DepositModuleException e) {
                this.logger.error(ACCOUNT_NOT_FOUND_MSG);
            }
            catch (UserManagementModuleException e) {
                this.logger.error(NO_USER_BY_IBAN, (Object)debtorAccount.getIban());
            }
        }
    }

    private boolean isAbsentTransactionBatch(PaymentTO payment) {
        DepositAccountBO account = this.depositAccountService.getAccountByIbanAndCurrency(payment.getDebtorAccount().getIban(), payment.getDebtorAccount().getCurrency());
        List transactions = this.depositAccountService.getTransactionsByDates(account.getId(), START_DATE, LocalDateTime.now());
        BigDecimal total = BigDecimal.ZERO.subtract(payment.getTargets().stream().map(PaymentTargetTO::getInstructedAmount).map(AmountTO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 5));
        return transactions.stream().noneMatch(t -> t.getTransactionAmount().getAmount().equals(total));
    }

    private boolean isAbsentTransactionRegular(String iban, Currency currency, String entToEndId) {
        DepositAccountBO account = this.depositAccountService.getAccountByIbanAndCurrency(iban, currency);
        List transactions = this.depositAccountService.getTransactionsByDates(account.getId(), START_DATE, LocalDateTime.now());
        return transactions.stream().noneMatch(t -> entToEndId.equals(t.getEndToEndId()));
    }

    private UserTO getUserByIban(List<UserTO> users, String iban) {
        return users.stream().filter(user -> this.isAccountContainedInAccess(user.getAccountAccesses(), iban)).findFirst().orElseThrow(() -> UserManagementModuleException.builder().build());
    }

    private void createAccounts() {
        for (AccountDetailsTO details : this.mockbankInitData.getAccounts()) {
            if (!this.currencyService.isCurrencyValid(details.getCurrency())) {
                throw new IllegalArgumentException("Currency is not supported: " + details.getCurrency());
            }
            DepositAccountBO account = this.depositAccountService.getOptionalAccountByIbanAndCurrency(details.getIban(), details.getCurrency()).orElseGet(() -> this.createAccount(details));
            this.updateBalanceIfRequired(details, account);
        }
    }

    private void updateBalanceIfRequired(AccountDetailsTO details, DepositAccountBO account) {
        this.getBalanceFromInitData(details).ifPresent(b -> this.updateBalance(details, account, b));
    }

    private void updateBalance(AccountDetailsTO details, DepositAccountBO account, BigDecimal balanceValue) {
        AmountBO amount = new AmountBO(details.getCurrency(), balanceValue);
        try {
            this.transactionService.depositCash(account.getId(), amount, "SYSTEM");
        }
        catch (DepositModuleException e) {
            this.logger.error("Unable to deposit cash to account: {} {}", (Object)details.getIban(), (Object)details.getCurrency());
        }
    }

    private Optional<BigDecimal> getBalanceFromInitData(AccountDetailsTO details) {
        return this.mockbankInitData.getBalances().stream().filter(this.getAccountBalancePredicate(details)).findFirst().map(AccountBalance::getBalance);
    }

    @NotNull
    private Predicate<AccountBalance> getAccountBalancePredicate(AccountDetailsTO details) {
        return b -> StringUtils.equals((CharSequence)b.getAccNbr(), (CharSequence)details.getIban()) && b.getCurrency().equals(details.getCurrency());
    }

    private DepositAccountBO createAccount(AccountDetailsTO details) {
        String userName = this.getUserNameByIban(details.getIban());
        DepositAccountBO accountBO = this.accountDetailsMapper.toDepositAccountBO(details);
        return this.depositAccountService.createNewAccount(accountBO, userName, "");
    }

    private String getUserNameByIban(String iban) {
        return this.mockbankInitData.getUsers().stream().filter(u -> this.isAccountContainedInAccess(u.getAccountAccesses(), iban)).findFirst().map(UserTO::getLogin).orElseThrow(() -> UserManagementModuleException.builder().build());
    }

    private boolean isAccountContainedInAccess(List<AccountAccessTO> access, String iban) {
        return access.stream().anyMatch(a -> a.getIban().equals(iban));
    }

    private void createUsers() {
        for (UserTO user : this.mockbankInitData.getUsers()) {
            try {
                this.userService.findByLogin(user.getLogin());
            }
            catch (UserManagementModuleException e) {
                user.getUserRoles().add(UserRoleTO.CUSTOMER);
                this.createUser(user);
            }
        }
    }

    private void createUser(UserTO user) {
        try {
            this.userService.create(this.userMapper.toUserBO(user));
        }
        catch (UserManagementModuleException e1) {
            this.logger.error("User already exists! Should never happen while initiating mock data!");
        }
    }
}

