/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.app.server;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDeserializer
extends StdDeserializer<LocalDateTime>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DateTimeDeserializer.class);
    private static final long serialVersionUID = 1905122041950251207L;
    private final transient DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MMdd'T'HH:mm:ss.SSS")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")).toFormatter();

    public DateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            String date = jsonParser.getText();
            return LocalDateTime.parse(date, this.formatter);
        }
        catch (IOException | DateTimeParseException e) {
            log.error("Unsupported dateTime format!");
            return null;
        }
    }
}

