/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.deposit.db.repository;

import de.adorsys.ledgers.deposit.db.domain.Payment;
import de.adorsys.ledgers.deposit.db.domain.PaymentType;
import de.adorsys.ledgers.deposit.db.domain.TransactionStatus;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface PaymentRepository
extends PagingAndSortingRepository<Payment, String> {
    public Optional<Payment> findByPaymentIdAndTransactionStatus(String var1, TransactionStatus var2);

    @Query(value="select p from Payment as p where p.transactionStatus = 'ACSP' and p.nextScheduledExecution <= current_timestamp")
    public List<Payment> getAllDuePayments();

    @Query(value="select p from Payment as p where p.debtorAccount.iban=?1 and p.debtorAccount.currency=?2 and p.paymentType=?3 and p.transactionStatus=?4")
    public List<Payment> findAllByDebtorAccount(String var1, String var2, PaymentType var3, TransactionStatus var4);
}

