/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.account;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum AccountTypeTO {
    CACC("Current"),
    CASH("CashPayment"),
    CHAR("Charges"),
    CISH("CashIncome"),
    COMM("Commission"),
    CPAC("ClearingParticipantSettlementAccount"),
    LLSV("LimitedLiquiditySavingsAccount"),
    LOAN("Loan"),
    MGLD("Marginal Lending"),
    MOMA("Money Market"),
    NREX("NonResidentExternal"),
    ODFT("Overdraft"),
    ONDP("OverNightDeposit"),
    OTHR("OtherAccount"),
    SACC("Settlement"),
    SLRY("Salary"),
    SVGS("Savings"),
    TAXE("Tax"),
    TRAN("TransactingAccount"),
    TRAS("Cash Trading");

    private static final Map<String, AccountTypeTO> container;
    private String value;

    private AccountTypeTO(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<AccountTypeTO> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    static {
        container = new HashMap<String, AccountTypeTO>();
        for (AccountTypeTO accountType : AccountTypeTO.values()) {
            container.put(accountType.getValue(), accountType);
        }
    }
}

